#pragma once

#include <drive/backend/database/history/propositions.h>

#include <rtline/util/types/accessor.h>

class TTagsManagerConfig {
private:
    R_READONLY(TPropositionsManagerConfig, DeviceTagPropositionsConfig);
    R_READONLY(THistoryConfig, TagDescriptionsHistoryConfig);
    R_READONLY(TPropositionsManagerConfig, TagDescriptionsPropositionsConfig);
    R_READONLY(THistoryConfig, UserTagsHistoryConfig);
    R_READONLY(THistoryConfig, DeviceTagsHistoryConfig);
    R_FIELD(TDuration, TagDescriptionsFreshness, TDuration::Seconds(20));
    R_READONLY(TString, TagsDBName);

public:
    void ToString(IOutputStream& os) const;
    void Init(const TYandexConfig::Section* section);
};
