#pragma once

#include "tags.h"

#include <drive/library/cpp/threading/concurrent_cache.h>

#include <rtline/library/unistat/signals.h>
#include <rtline/util/auto_actualization.h>

class IEntityTagsManager;

class TTagCache: public IAutoActualization {
public:
    using TExpectedTaggedObject = TExpected<TTaggedObject, TCodedException>;
    using TOptionalTaggedObject = TMaybe<TTaggedObject>;

public:
    TTagCache(const IEntityTagsManager& tagManager, const TString& tableName, TDuration defaultLifetime);

    TExpectedTaggedObject GetCachedObject(const TString& objectId, TInstant statementDeadline = TInstant::Zero()) const;
    TOptionalTaggedObject GetCachedObject(const TString& objectId, NDrive::TEntitySession& tx) const;

protected:
    bool GetStartFailIsProblem() const override;
    bool Refresh() override;
    bool Update(const TTaggedObject& object) const;

private:
    const IEntityTagsManager& TagManager;
    const TDuration DefaultLifetime;

    TUnistatSignal<double> CacheHit;
    TUnistatSignal<double> CacheMiss;
    TUnistatSignal<double> CacheExpired;
    TUnistatSignal<double> CacheInvalidated;
    TOptionalTagHistoryEventId LastEventId;

    mutable NUtil::TConcurrentCache<TString, TTaggedObject> ObjectCache;
};
