#include "tags_filter.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TagsFilter) {
    Y_UNIT_TEST(RepeatedTokens) {
        auto filterString = "(model_audi_a3)*(model_audi_a3)";
        auto filter = TTagsFilter::BuildFromString(filterString);
        Cerr << filter.GetDebugInfo().GetStringRobust() << Endl;

        TVector<TString> tags = {
            "model_audi_a3"
        };
        UNIT_ASSERT(filter.IsMatching(tags));
    }

    Y_UNIT_TEST(RepeatedTags) {
        auto filterString = "model_audi_a3*-model_ford";
        auto filter = TTagsFilter::BuildFromString(filterString);
        Cerr << filter.GetDebugInfo().GetStringRobust() << Endl;
        UNIT_ASSERT(filter.GetRelatedTagNames().contains("model_audi_a3"));
        UNIT_ASSERT(filter.GetRelatedTagNames().contains("model_ford"));
    }
}
