#pragma once

#include <drive/backend/proto/matcher.pb.h>

#include <drive/library/cpp/tracks/client.h>
#include <drive/library/cpp/tracks/interface.h>

#include <rtline/api/graph/metrics/quality.h>
#include <rtline/library/storage/structured.h>

namespace NDrive {
    class IServer;
}

class TSessionTrackClient: public NDrive::ITrackClient {
public:
    static NDrive::ECarStatus GetStatus(TStringBuf tag);

public:
    TSessionTrackClient(NDrive::TTrackClientPtr client, const NDrive::IServer& server);

    NThreading::TFuture<NDrive::TTracks> GetTracks(const NDrive::TTrackQuery& query, TDuration timeout) const override;

private:
    NDrive::TTrackClientPtr Client;
    const NDrive::IServer& Server;
};

THolder<NDrive::ITrackClient> CreateTrackClient(const TString& name, const NDrive::IServer& server);
THolder<NDrive::ITrackClient> CreateCameraTrackClient(const NDrive::IServer& server);

class TYDBTracksClient {
public:
    TYDBTracksClient(const NDrive::IServer& server, const NDrive::TTracksLinker::TOptions& options);

    NDrive::TTracksLinker::TResults GetYDBTracks(const NDrive::TTrackQuery& trackQuery);

private:
    NDrive::TTracksLinker::TResults ParseYdbTracks(const TRecordsSet& records, TInstant since = TInstant::Zero(), TInstant until = TInstant::Max()) const;
    TRange<ui64> GetYDBRange(const NDrive::TTrackQuery& trackQuery, TInstant maxTime) const;
    // TODO: finish violation calculation eyurkovsk
    TSpeedLimitRanges GetSpeedLimitRanges(const TVector<NDrive::NProto::TMatchedCoordinate>& coordinates) const;
    TSpeedLimitRanges AnalyzeSpeedLimitRange(TSpeedLimitRanges& ranges) const;

private:
    const NDrive::IServer& Server;
    NDrive::TTracksLinker::TOptions Options;
};
