#pragma once

#include <drive/backend/cars/car.h>
#include <drive/backend/database/history/event.h>

#include <util/datetime/base.h>

namespace NDrive {
    class TMatcherEvent {
    public:
        TMatcherEvent() = default;
        TMatcherEvent(const TObjectEvent<TDriveCarInfo>& event);
        TMatcherEvent(i64 historyEventId, EObjectHistoryAction action, const TString& objectId, const TString& imei, const TInstant timestamp);

    private:
        R_FIELD(i64, HistoryEventId, 0);
        R_FIELD(EObjectHistoryAction, HistoryAction);
        R_FIELD(TString, ObjectId);
        R_FIELD(TString, Imei);
        R_FIELD(TInstant, Timestamp, TInstant::Zero());
    };

    class IObjectIdMatcherHistory {
    public:
        virtual TString GetObjectId(const TString& imei, TMaybe<TInstant> timestamp = {}) = 0;
        //virtual TVector<TString> GetImeis(const TString& objectId) = 0;
    };

    struct ImeiInfo {
        TString Imei;
        TString ObjectId;
        TInstant BeginTime;
        TInstant EndTime;

        ImeiInfo();
        ImeiInfo(const TString& imei, const TString& objectId, TInstant begin);
    };

    class TYTObjectIdMatcherHistory : public IObjectIdMatcherHistory {
    public:
        TString GetObjectId(const TString& imei, TMaybe<TInstant> timestamp = {}) override;
        bool UpdateHistory(const NJson::TJsonValue& json, bool needDroppedHistory = true);
        void AddEvent(const TMatcherEvent& event);

        void Save(IOutputStream* out) const;
        void Load(IInputStream* in);

    private:
        //only for production/prestable data
        TVector<TMatcherEvent> GetDroppedImeiHistory();

    private:
        R_FIELD(i64, LastEventId, 0);
        R_FIELD(TInstant, Actuality, TInstant::Zero());
        TVector<ImeiInfo> ImeisHistory;
        THashMap<TString /*objectId*/, TVector<ui32> /*vectorIndex*/> ObjectIds;
        THashMap<TString /*imei*/, TVector<ui32> /*vectorIndex*/> Imeis;
    };
}
