#pragma once

#include <drive/library/cpp/tracks/client.h>

class TJsonReport;

namespace NDrive {
    class IAnalyzerReport {
    public:
        virtual ~IAnalyzerReport() = default;

        virtual void Fill(TJsonReport& report) = 0;
        virtual void Fill(NJson::TJsonValue& value) = 0;

        virtual void OnStartTrack(const TTrack& track) = 0;
        virtual void OnStartSegment(const NGraph::TRouter::TMatch& match, const NGraph::TRouter::TTimedGeoCoordinates& coordinates) = 0;
        virtual void OnSegmentRange(const TSpeedLimitRange& range, const NGraph::TRouter::TTimedGeoCoordinates& coordinates) = 0;
        virtual void OnFinishSegment(const NGraph::TRouter::TMatch& match, const NGraph::TRouter::TTimedGeoCoordinates& coordinates) = 0;
        virtual void OnFinishTrack(const TTrack& track) = 0;

        virtual bool UseDirectOrder() const = 0;
    };

    THolder<IAnalyzerReport> CreateAnalyzerReport(TStringBuf format);

    template <class T>
    T GetAnalyzerReport(TConstArrayRef<TTracksLinker::TResult> results, TStringBuf format);

    template <class T>
    T GetAnalyzerReport(const TTracksLinker::TResult& result, TStringBuf format) {
        return GetAnalyzerReport<T>({ &result, 1}, format);
    }

    NJson::TJsonValue ToGeoJsonFormat(const TTracks& tracks);
    NJson::TJsonValue ToLegacyFormat(const TTracks& tracks);
}
