#pragma once

#include <drive/library/cpp/tracks/interface.h>
#include <drive/library/cpp/taxi/driver_trackstory/client.h>

class TTaxiTrackStoryClient;

namespace NDrive {
    class IServer;
}

class TYAGRTrackClient: public NDrive::ITrackClient {
public:
    TYAGRTrackClient(const NDrive::IServer& server);

    NThreading::TFuture<NDrive::TTracks> GetTracks(const NDrive::TTrackQuery& query, TDuration timeout) const override;

private:
    const NDrive::IServer& Server;
    const TTaxiTrackStoryClient* Client;
};

class TYAGRTrackClientV2: public NDrive::ITrackClient {
public:
    TYAGRTrackClientV2(const NDrive::IServer& server);
    NThreading::TFuture<NDrive::TTracks> GetTracks(const NDrive::TTrackQuery& query, TDuration timeout) const;

private:
    const NDrive::IServer& Server;
    const TTaxiTrackStoryClient* Client;
};
