#include "client.h"

#include <library/cpp/json/json_reader.h>

#include <util/generic/yexception.h>
#include <util/string/builder.h>
#include <util/system/env.h>

namespace NDrive {

    TObjectIdMatcherClient::TObjectIdMatcherClient(TOptions options)
        : Client(MakeHolder<NNeh::THttpClient>(options.Endpoint))
        , Options(options)
    {
    }

    NThreading::TFuture<NJson::TJsonValue> TObjectIdMatcherClient::GetHistory(TMaybe<ui32> lastEventId) const {
        NNeh::THttpRequest request;
        request.SetUri("/api/staff/car/id_matcher_history");
        if (lastEventId) {
            request.SetCgiData(TStringBuilder() << "last_event_id" << '=' << lastEventId);
        }
        request.SetOAuthToken(GetEnv("DRIVE_TOKEN"));

        auto reply = Yensured(Client)->SendAsync(request, Now() + Options.Timeout);
        return reply.Apply([](const NThreading::TFuture<NUtil::THttpReply>& r) {
            const NUtil::THttpReply& reply = r.GetValue();
            if (reply.IsUserError()) {
                ythrow yexception() << "TObjectIdMatcherClient: response user error. Message: " << reply.Serialize();
            }
            if (reply.IsServerError()) {
                ythrow yexception() << "TObjectIdMatcherClient: response server error. Message: " << reply.Serialize();
            }
            reply.EnsureSuccessfulReply();
            return NJson::ReadJsonFastTree(reply.Content());
        });
    }
}
