#pragma once

#include <rtline/util/network/neh.h>

namespace NDrive {

    class TObjectIdMatcherClient {
    public:
        struct TOptions {
            TString Endpoint;
            TDuration Timeout;
        };

        TObjectIdMatcherClient(TOptions options);
        NThreading::TFuture<NJson::TJsonValue> GetHistory(TMaybe<ui32> lastEventId = {}) const;

    private:
        THolder<NNeh::THttpClient> Client;
        TOptions Options;
    };
}
