#pragma once

#include <drive/backend/proto/matcher.pb.h>

#include <maps/analyzer/libs/data/include/gpssignal.h>
#include <maps/analyzer/libs/graphmatching/include/candidate.h>
#include <maps/analyzer/libs/graphmatching/include/match_signals.h>

#include <library/cpp/yson/node/node.h>

#include <rtline/library/geometry/coord.h>

#include <util/datetime/base.h>

struct TMatchedSignal {
    TString Status;
    TInstant Timestamp;
    TString UserId;
    TString ObjectId;
    TString SessionId;
    TGeoCoord Coordinate;
    double Speed; // in m/s
    double SpeedLimit; // in m/s
    ui32 FC;
    double LenghtToPreviuosPoint = 0; // in meters
    maps::road_graph::EdgeId EdgeId;

    TMatchedSignal(const maps::analyzer::data::GpsSignal& signal, const maps::geolib3::Point2& point, const maps::road_graph::EdgeData& data, const double& length);

    bool operator < (const TMatchedSignal& signal) const;

    NDrive::NProto::TMatchedCoordinate SerializeToProto() const;
};

void AddMatchedPoints(TVector<TMatchedSignal>& allPoints, const maps::analyzer::data::GpsSignal& signal, const maps::analyzer::graphmatching::Candidate& candidate, const maps::road_graph::Graph& roadGraph);

NYT::TNode SerializeToYtNode(const TVector<TMatchedSignal>& signals);
