#include "config.h"

#include <drive/library/cpp/aes/crypto.h>

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/file.h>


void TDocumentPhotosConfig::Init(const TYandexConfig::Section* section) {
    BucketName = section->GetDirectives().Value<TString>("BucketName", BucketName);
    PhotoAccessPathPrefix = section->GetDirectives().Value<TString>("PhotoAccessPathPrefix", PhotoAccessPathPrefix);
    PhotoAccessPathPostfix = section->GetDirectives().Value<TString>("PhotoAccessPathPostfix", PhotoAccessPathPostfix);

    ContentEncryptionKeyHR = section->GetDirectives().Value<TString>("ContentEncryptionKey", ContentEncryptionKeyHR);
    if (!ContentEncryptionKeyHR) {
        TString tokenPath;
        tokenPath = section->GetDirectives().Value<TString>("ContentEncryptionKeyPath", tokenPath);
        if (!!tokenPath) {
            ContentEncryptionKeyHR = Strip(TFileInput(tokenPath).ReadAll());
        }
    }
    CHECK_WITH_LOG(ContentEncryptionKeyHR.size() == 64);  // 256 bit key is used for documents

    for (size_t i = 0; i < ContentEncryptionKeyHR.size() / 2; ++i) {
        auto firstByte = TCryptoGCMProcessor::HexDigitToInt(ContentEncryptionKeyHR[i * 2]);
        auto secondByte = TCryptoGCMProcessor::HexDigitToInt(ContentEncryptionKeyHR[i * 2 + 1]);
        ContentEncryptionKey[i] = (firstByte << 4) + secondByte;
    }
}

void TDocumentPhotosConfig::ToString(IOutputStream& os) const {
    os << "BucketName: " << BucketName << Endl;
    os << "ContentEncryptionKey: " << ContentEncryptionKeyHR << Endl;
    os << "PhotoAccessPathPrefix: " << PhotoAccessPathPrefix << Endl;
    os << "PhotoAccessPathPostfix: " << PhotoAccessPathPostfix << Endl;
}
