#pragma once

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/logger/global/global.h>

#include <rtline/util/types/accessor.h>

class TDocumentPhotosConfig {
    R_READONLY(TString, BucketName);
    R_READONLY(TString, ContentEncryptionKeyHR);
    R_READONLY(TString, PhotoAccessPathPrefix);
    R_READONLY(TString, PhotoAccessPathPostfix);

private:
    unsigned char ContentEncryptionKey[32];

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    const unsigned char* GetContentEncryptionKey() const {
        return ContentEncryptionKey;
    }

    static TDocumentPhotosConfig ParseFromString(const TString& configStr) {
        TDocumentPhotosConfig result;
        TAnyYandexConfig config;
        CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
        result.Init(config.GetRootSection());
        return result;
    }
};
