#pragma once

#include <drive/library/cpp/renins/entities.h>
#include <drive/backend/user_insurance/proto/entities.pb.h>

#include <rtline/util/types/accessor.h>

namespace NDrive::NRenins {
    const ui32 StsNumberSize = 4;
    const ui32 LicenseSeriesSize = 4;
    const ui32 PassportSeriesSize = 4;

    enum class EKaskoStatus {
        NoData          /* "no_data" */,
        Calculated      /* "calculated" */,
        Processing      /* "processing" */,
        NeedPso         /* "need_pso" */,
        Ordered         /* "ordered" */,
        Signed          /* "signed" */,
        Error           /* "error" */,
    };

    class TReportCarData {
        R_FIELD(TString, Brand);
        R_FIELD(TString, Model);
    };

    class TKaskoData {
        R_FIELD(TString, TagId);
        R_FIELD(TString, PackageName);
        R_FIELD(TString, OrderId);
        R_FIELD(TString, Franchise);
        R_FIELD(TInstant, InsuranceStart, TInstant::Zero());
        R_FIELD(TInstant, InsuranceEnd, TInstant::Zero());
        R_FIELD(NDrive::NRenins::NKasko::TCarOrderStartData, Car);
        R_FIELD(TReportCarData, CarReportData);
        R_FIELD(TVector<TString>, Drivers);
        R_FIELD(ui32, CalcFinalPrice, 0);
        R_FIELD(ui32, OrderFinalPrice, 0);
        R_FIELD(ui32, Discount, 0);
        R_OPTIONAL(NDrive::NRenins::NKasko::TOrderStatus, Status);
        R_FIELD(TString, PaymentLink);
        R_FIELD(TString, DocumentPath);
        R_FIELD(NJson::TJsonValue, Conditions);
        R_FIELD(TString, ErrorType);
        R_FIELD(TString, ErrorText);

    public:
        NJson::TJsonValue SerializeToJson() const;
        NProto::TKaskoOrderData SerializeToProto() const;
        bool DeserializeFromProto(const NProto::TKaskoOrderData& proto);
        EKaskoStatus GetStatus() const;
    };

    TMaybe<NKasko::TAutoData> ParseKaskoCarData(const NJson::TJsonValue& json);
    TMaybe<NKasko::TCarOrderStartData> ParseCarKaskoOrderData(const NJson::TJsonValue& json);
    TMaybe<NKasko::TDriverOrderStartData> ParseDriverKaskoOrderData(const NJson::TJsonValue& json);
}
