#include "blacklist_external.h"

TDriveUserData TBlacklistExternal::ConstructExternalBlacklistUser(const EBlacklistUserField field, const TString& value) const {
    TDriveUserData user;
    user.SetUserId("uuid_generate_v4()");
    if (field == EBlacklistUserField::DrivingLicenseNumber) {
        user.SetDrivingLicenseNumberHash(value);
    } else if (field == EBlacklistUserField::PassportNumber) {
        user.SetPassportNumberHash(value);
    } else if (field == EBlacklistUserField::PhoneNumber) {
        user.SetPhone(value);
    }
    user.SetUid("get_null()");
    return user;
}

ITag::TPtr TBlacklistExternal::ConstructTag(const EBanPolicy& policy, const TString& comment) const {
    if (policy == EBanPolicy::Block) {
        return IJsonSerializableTag::BuildWithComment<TUserProblemTag>("blocked_external_blacklist", comment);
    } else {
        return IJsonSerializableTag::BuildWithComment<TUserProblemTag>("suspicious_from_external_blacklist", comment);
    }
}

bool TBlacklistExternal::AddRecord(const EBlacklistUserField field, const TString& value, const TString& operatorUserId, const EBanPolicy& banPolicy, const TString& comment, const NDrive::IServer* server, NDrive::TEntitySession& session) const {
    TDriveUserData fakeUser = ConstructExternalBlacklistUser(field, value);

    auto newUser = UsersDB.UpdateUser(fakeUser, operatorUserId, session, true);
    if (!newUser) {
        return false;
    }

    auto tag = ConstructTag(banPolicy, comment);
    auto optionalAddedTags = UserTagsManager.AddTag(tag, operatorUserId, newUser->GetUserId(), server, session);
    return optionalAddedTags.Defined();
}
