#pragma once

#include "user.h"

#include <drive/backend/data/common/serializable.h>
#include <drive/backend/data/user_tags.h>
#include <drive/backend/database/entity/manager.h>
#include <drive/backend/tags/tags_manager.h>

#include <rtline/library/storage/structured.h>

enum EBlacklistUserField {
    DrivingLicenseNumber /* "driving_license_number" */,
    PassportNumber /* "passport_number" */,
    PhoneNumber /* "phone_number" */
};

enum EBanPolicy {
    Block /* "block" */,
    MarkSuspicious /* "mark_suspicious" */,
};

class TUserProblemTag;

class TBlacklistExternal {
private:
    const TUsersDB& UsersDB;
    const IEntityTagsManager& UserTagsManager;

    TDriveUserData ConstructExternalBlacklistUser(const EBlacklistUserField field, const TString& value) const;

    ITag::TPtr ConstructTag(const EBanPolicy& policy, const TString& comment) const;

public:
    TBlacklistExternal(const TUsersDB& usersDB, const TUserTagsManager& tagsManager)
        : UsersDB(usersDB)
        , UserTagsManager(tagsManager)
    {
    }

    bool AddRecord(const EBlacklistUserField field, const TString& value, const TString& operatorUserId, const EBanPolicy& banPolicy, const TString& comment, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
};
