#include "login.h"

bool TLoginsManager::GetUserIdByLogin(const ELoginType type, const TString& login, const TString& deviceId, const TInstant reqActuality, TString& result) const {
    const TString key = ToString(type) + "-" + login + "-" + deviceId;
    auto cacheResult = Cache.GetData(key, result, reqActuality);
    if (cacheResult == ECachedValue::HasData) {
        return true;
    } else if (cacheResult == ECachedValue::Absent) {
        result = "";
        return true;
    }
    NStorage::ITransaction::TPtr t = Database->CreateTransaction(true);
    NStorage::ITableAccessor::TPtr table = Database->GetTable("user_logins");
    TStringStream ss = "login_type = '" + ToString(type) + "' ";
    ss << "AND login_id = '" << login << "' ";
    ss << "AND (device_id = '' OR device_id = '" << deviceId << "')";
    TRecordsSet records;
    NStorage::IQueryResult::TPtr reqResult = table->GetRows(ss.Str(), records, t);
    if (!reqResult->IsSucceed()) {
        return false;
    } else if (records.GetRecords().size() > 1) {
        ERROR_LOG << "Incorrect table info about login (" << type << ", " << login << ", " << deviceId << ")";
        return false;
    } else if (records.GetRecords().size() == 1) {
        CHECK_WITH_LOG(records.GetRecords().front().TryGet("user_id", result));
        return true;
    }
    result = "";
    return true;
}

bool TLoginsManager::AddLogin(const TUserLogin& login, NDrive::TEntitySession& session) const {
    NStorage::TTableRecord record = login.SerializeToTableRecord();
    NStorage::ITransaction::TPtr t = session.GetTransaction();
    NStorage::ITableAccessor::TPtr table = Database->GetTable("user_logins");

    NStorage::TTableRecord recordUnique = record;
    recordUnique.Remove("user_id");
    if (!table->AddIfNotExists(record, t, recordUnique)->IsSucceed()) {
        session.SetErrorInfo("add_logins", session.GetStringReport(), EDriveSessionResult::TransactionProblem);
        ERROR_LOG << "Error on login add: " << t->GetErrors().GetStringReport() << Endl;
        return false;
    } else {
        return true;
    }
}

bool TLoginsManager::GetLogins(const TString& userId, TVector<TUserLogin>& result, NDrive::TEntitySession& session) const {
    NStorage::ITableAccessor::TPtr table = Database->GetTable("user_logins");
    NStorage::TTableRecord record;
    record.Set("user_id", userId);
    TRecordsSet records;
    if (!table->GetRows(record.BuildCondition(*session.GetTransaction()), records, session.GetTransaction())->IsSucceed()) {
        session.SetErrorInfo("get_logins", session.GetStringReport(), EDriveSessionResult::TransactionProblem);
        return false;
    }
    for (auto&& i : records) {
        TUserLogin login;
        CHECK_WITH_LOG(login.DeserializeFromTableRecord(i));
        result.push_back(login);
    }
    return true;
}

bool TLoginsManager::RemoveLogin(const TUserLogin& login, NDrive::TEntitySession& session) const {
    NStorage::TTableRecord record = login.SerializeToTableRecord();
    NStorage::ITransaction::TPtr t = session.GetTransaction();
    NStorage::ITableAccessor::TPtr table = Database->GetTable("user_logins");

    record.Remove("user_id");
    if (!table->RemoveRow(record, t)->IsSucceed()) {
        session.SetErrorInfo("remove_logins", session.GetStringReport(), EDriveSessionResult::TransactionProblem);
        ERROR_LOG << "Error on login remove: " << t->GetErrors().GetStringReport() << Endl;
        return false;
    } else {
        return true;
    }
}
