#include <drive/backend/ut/library/helper.h>
#include <drive/backend/ut/library/script.h>

#include <drive/backend/compiled_riding/manager.h>
#include <drive/backend/data/chargable.h>
#include <drive/backend/data/device_tags.h>
#include <drive/backend/offers/context.h>
#include <drive/backend/offers/actions/correctors.h>
#include <drive/backend/offers/actions/standart.h>
#include <drive/backend/offers/actions/ut/library/helper.h>
#include <drive/backend/offers/ranking/calcer.h>
#include <drive/backend/offers/ranking/model.h>
#include <drive/backend/sessions/manager/billing.h>

#include <drive/telematics/server/library/config.h>
#include <drive/telematics/server/ut/library/helper.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/util/algorithm/ptr.h>

#include <util/system/env.h>

Y_UNIT_TEST_SUITE(CalculatorSuite) {
    const auto SessionChecker = [](const NDrive::NTest::TRTContext& context, const NJson::TJsonValue& json)->bool {
        INFO_LOG << json.GetStringRobust() << Endl;
        ui32 totalSum = json["segment"]["session"]["specials"]["total_price"].GetUIntegerSafe();
        UNIT_ASSERT(totalSum > 0);
        TString sessionId = json["segment"]["session"]["specials"]["current_offer"]["offer_id"].GetString();

        const auto& compiledRidesManager = context.GetDriveAPI().GetMinimalCompiledRides();
        auto tx = compiledRidesManager.BuildSession(true);
        auto defaultTx = NDrive::TEntitySession();
        auto sessions = compiledRidesManager.Get<TMinimalCompiledRiding>({sessionId}, tx, defaultTx);
        UNIT_ASSERT(sessions);
        UNIT_ASSERT_VALUES_EQUAL(sessions->size(), 1);

        {
            auto optionalSession = context.GetDriveAPI().GetSessionManager().GetSession(sessionId, tx);
            UNIT_ASSERT(optionalSession);
            auto bSession = *optionalSession;
            UNIT_ASSERT(bSession);

           // TBillingSession::TBillingCompilation bCompilationStart;
           // bCompilationStart.SetUntil(bSession->GetStartTS());
            TBillingSession::TBillingCompilation bCompilationUntil;
            bCompilationUntil.SetUntil(bSession->GetLastTS());

            //UNIT_ASSERT(bSession->FillCompilation(bCompilationStart));
            UNIT_ASSERT(bSession->FillCompilation(bCompilationUntil));

            //const i32 billingPrice = bCompilationUntil.GetBillingSumPrice() - bCompilationStart.GetBillingSumPrice();
            const i32 reportPrice = bCompilationUntil.GetReportSumPrice();
            UNIT_ASSERT_VALUES_EQUAL(reportPrice, totalSum);
        }
        {
            TMessagesCollector errors;
            auto compiledSession = TBillingSession::BuildFromCompiled(context.GetServer().Get(), sessions->front(), errors);
            UNIT_ASSERT(compiledSession);

         //   TBillingSession::TBillingCompilation bCompilationStart;
         //   bCompilationStart.SetUntil(compiledSession->GetStartTS());
            TBillingSession::TBillingCompilation bCompilationUntil;
            bCompilationUntil.SetUntil(compiledSession->GetLastTS());

        //    UNIT_ASSERT(compiledSession->FillCompilation(bCompilationStart));
            UNIT_ASSERT(compiledSession->FillCompilation(bCompilationUntil));

            //const i32 billingPrice = bCompilationUntil.GetBillingSumPrice() - bCompilationStart.GetBillingSumPrice();
            const i32 reportPrice = bCompilationUntil.GetReportSumPrice();
            UNIT_ASSERT_VALUES_EQUAL(reportPrice, totalSum);
        }
        return true;
    };

    Y_UNIT_TEST(StandartCompiledCalculator) {
        NDrive::TServerConfigGenerator configGenerator;
        configGenerator.SetNeedBackground(0);
        configGenerator.SetLogLevel(6);
        NDrive::NTest::TScript script(configGenerator);
        script.Add<NDrive::NTest::TBuildEnv>();
        script.Add<NDrive::NTest::TSetScriptUser>(USER_ID_DEFAULT);

        TGeoCoord from(37.5848674, 55.7352435);
        TGeoCoord to(37.5675511, 55.7323499);
        script.Add<NDrive::NTest::TCreateCar>().SetPosition(from);
        script.Add<NDrive::NTest::TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("standart_offer_constructor").SetUserPosition(from);
        script.Add<NDrive::NTest::TAccept>(TDuration::Zero());
        script.Add<NDrive::NTest::TRide>(TDuration::Minutes(1));
        script.Add<NDrive::NTest::TDrop>(TDuration::Minutes(2)).SetCarPosition(to);
        script.Add<NDrive::NTest::TDropCache>();
        script.Add<NDrive::NTest::TCheckCurrentSessionWaiting>().SetChecker(SessionChecker);
        UNIT_ASSERT(script.Execute());
    }

    Y_UNIT_TEST(FixCompiledCalculator) {
        NDrive::TServerConfigGenerator configGenerator;
        configGenerator.SetNeedBackground(0);
        configGenerator.SetLogLevel(6);
        NDrive::NTest::TScript script(configGenerator);
        script.Add<NDrive::NTest::TBuildEnv>();
        script.Add<NDrive::NTest::TSetScriptUser>(USER_ID_DEFAULT);

        TGeoCoord from(37.5848674, 55.7352435);
        TGeoCoord to(37.5675511, 55.7323499);
        script.Add<NDrive::NTest::TCreateCar>().SetPosition(from);
        script.Add<NDrive::NTest::TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("fixpoint_offer_constructor").SetUserPosition(from);
        script.Add<NDrive::NTest::TAccept>(TDuration::Zero());
        script.Add<NDrive::NTest::TRide>(TDuration::Zero());
        script.Add<NDrive::NTest::TDrop>(TDuration::Minutes(2)).SetCarPosition(to);
        script.Add<NDrive::NTest::TDropCache>();
        script.Add<NDrive::NTest::TCheckCurrentSessionWaiting>().SetChecker(SessionChecker);
        UNIT_ASSERT(script.Execute());
    }


    Y_UNIT_TEST(PackCompiledCalculator) {
        NDrive::TServerConfigGenerator configGenerator;
        configGenerator.SetNeedBackground(0);
        configGenerator.SetLogLevel(6);
        NDrive::NTest::TScript script(configGenerator);
        script.Add<NDrive::NTest::TBuildEnv>();
        script.Add<NDrive::NTest::TSetScriptUser>(USER_ID_DEFAULT);

        TGeoCoord from(37.5848674, 55.7352435);
        TGeoCoord to(37.5675511, 55.7323499);
        script.Add<NDrive::NTest::TCreateCar>().SetPosition(from);
        script.Add<NDrive::NTest::TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("pack_offer_constructor").SetUserPosition(from);
        script.Add<NDrive::NTest::TAccept>(TDuration::Zero());
        script.Add<NDrive::NTest::TRide>(TDuration::Zero());
        script.Add<NDrive::NTest::TDrop>(TDuration::Minutes(2)).SetCarPosition(to);
        script.Add<NDrive::NTest::TDropCache>();
        script.Add<NDrive::NTest::TCheckCurrentSessionWaiting>().SetChecker(SessionChecker);
        UNIT_ASSERT(script.Execute());
    }
}
