#include <drive/backend/ut/library/helper.h>

#include <drive/backend/tags/tags.h>
#include <drive/backend/tags/tags_manager.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(Encrypted) {

    Y_UNIT_TEST(Basics) {
        NDrive::TServerConfigGenerator gServer;
        TServerConfigConstructorParams params(gServer.GetString().data());
        NDrive::TServerConfig config(params);
        NDrive::TServerGuard server(config);
        TEnvironmentGenerator eGenerator(*server.Get());
        eGenerator.BuildEnvironment();

        auto cipher = server->GetCipher("test_aes");
        UNIT_ASSERT(!!cipher);

        TString origin = "fdsahkjfhakjfdhakjsd hfkbsadkjfxhbdsabfxkdsabfxk dkj";
        TString encrypted = origin;
        UNIT_ASSERT(cipher->Encrypt(origin, encrypted));
        UNIT_ASSERT_C(encrypted != origin, TStringBuilder() << encrypted);
        TString revert;
        UNIT_ASSERT(cipher->Decrypt(encrypted, revert));
        UNIT_ASSERT_VALUES_EQUAL(revert, origin);
    }
}
