#include <drive/backend/ut/library/helper.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ExternalAccessToken) {
    Y_UNIT_TEST(MosgorpasScenario){
        NDrive::TServerConfigGenerator configGenerator;
        TServerConfigConstructorParams params(configGenerator.GetString().data());
        NDrive::TServerConfig config(params);
        NDrive::TServerGuard server(config);
        // const TDriveAPI& driveApi = *server->GetDriveAPI();
        TEnvironmentGenerator eGenerator(*server.Get());
        eGenerator.BuildEnvironment(TEnvironmentGenerator::DefaultTraits - (ui32)EEnvironmentFeatures::Default);

        auto reply = configGenerator.UpsertExternalAccessToken(USER_ID_DEFAULT1, "token1", TVector<TString>{"1:1:1:1::/64"}, USER_ROOT_DEFAULT);
        UNIT_ASSERT_VALUES_EQUAL(reply.Code(), 200);
        NJson::TJsonValue report = NJson::JSON_NULL;
        if (!NJson::ReadJsonFastTree(reply.Content(), &report)) {
            ERROR_LOG << reply.Code() << " : " << reply.Content() << Endl;
        }
        UNIT_ASSERT_VALUES_EQUAL(report["user_id"], USER_ID_DEFAULT1);
        UNIT_ASSERT_VALUES_EQUAL(report["token"], "token1");
        UNIT_ASSERT(report.Has("ip_whitelist"));

        auto car = eGenerator.CreateCar();
        reply = configGenerator.CreateMosgorpasOffer(car.Id, "token1", "1:1:1:1:1:1:1:1");
        UNIT_ASSERT_VALUES_EQUAL(reply.Code(), 200);
        if (!NJson::ReadJsonFastTree(reply.Content(), &report)) {
            ERROR_LOG << reply.Code() << " : " << reply.Content() << Endl;
        }
        UNIT_ASSERT(report.Has("offers"));
        UNIT_ASSERT(report.Has("deeplink"));

        bool success = configGenerator.InvalidateExternalAccessToken("token1", USER_ROOT_DEFAULT);
        UNIT_ASSERT(success);

        reply = configGenerator.CreateMosgorpasOffer(car.Id, "token1", "1:1:1:1:1:1:1:1");
        UNIT_ASSERT_VALUES_EQUAL(reply.Code(), 401);
    }
}
