#include <drive/backend/ut/library/helper2.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(FastRegistration) {
    Y_UNIT_TEST(CurrentSession) {
        TTestEnvironment env;
        env.Execute(NDrive::NTest::TBuildEnv());

        auto userId = env.GetEnvironmentGenerator().CreateUser("superfast_jellyfish", true, "onboarding");
        {
            auto currentSession = env->GetCurrentSession(userId);
            INFO_LOG << currentSession.GetStringRobust() << Endl;
            UNIT_ASSERT(currentSession.IsDefined());
            UNIT_ASSERT_VALUES_EQUAL(currentSession["user"]["show_chat"]["id"].GetStringRobust(), "registration");
        }
        UNIT_ASSERT(
            env->AddTag(MakeHolder<TRegistrationUserTag>("fast_registration_available"), userId, USER_ROOT_DEFAULT, NEntityTagsManager::EEntityType::User)
        );
        {
            auto currentSession = env->GetCurrentSession(userId);
            INFO_LOG << currentSession.GetStringRobust() << Endl;
            UNIT_ASSERT(currentSession.IsDefined());
            UNIT_ASSERT_VALUES_EQUAL(currentSession["user"]["show_chat"]["id"].GetStringRobust(), "registration_light");
        }
    }
}
