#include <drive/backend/ut/library/helper2.h>


Y_UNIT_TEST_SUITE(LandingsProposition) {
    Y_UNIT_TEST(LandingProposeConfirmReject) {
        TTestEnvironment env;
        env.Execute(NDrive::NTest::TBuildEnv());

        const TString landing = R"({
            "landing_json_substitute": true,
            "landing_enabled": true,
            "landing_chat_enabled": false,
            "landing_check_auditory_condition_in_list": false,
            "landing_auditory_condition": {
                "type": "or",
                "subconditions": [
                    {
                        "name": "ios",
                        "type": "platform"
                    },
                    {
                        "type": "and",
                        "subconditions": [
                            {
                                "name": "android_client",
                                "type": "platform"
                            },
                            {
                                "min_value": 7066,
                                "type": "min_app_build"
                            }
                        ]
                    }
                ]
            },
            "landing_json": {
                "button_style": "solid",
                "points": [
                    "abs"
                ],
                "other_buttons": [],
                "title": "Бесплатный проезд [event_timestamp]",
                "type": "common_bbcode",
                "color1": "#null",
                "button_color": "#fff",
                "is_closable": false,
                "button": "Оукей",
                "color2": "#39b6b9",
                "button_type": "close"
            },
            "landing_id": "test_landing_test",
            "landing_priority": -100,
            "revision": 1
            })";

        auto userPropose = TString{USER_ROOT_DEFAULT};
        auto userConfirm = TString{USER_ID_DEFAULT2};

        env->Request(userPropose, "api/staff/landing/get");

        // propose
        NJson::TJsonValue jsonLanding;
        UNIT_ASSERT(ReadJsonFastTree(landing, &jsonLanding));
        env->Request(userPropose, "api/staff/landing/propose", "comment=landings_test1_propose", jsonLanding);

        auto landingsGet = env->Request(userPropose, "api/staff/landing/get");
        UNIT_ASSERT(landingsGet.IsDefined());

        {
            NJson::TJsonValue propositionId;

            for (const auto& propose : landingsGet["propositions"].GetArray())
            {
                if (propose["landing_id"].GetString() == jsonLanding["landing_id"].GetString())
                {
                    propositionId["proposition_ids"] = propose["proposition_id"].GetString();
                    break;
                }
            }
            // confirm
            UNIT_ASSERT(propositionId.IsDefined());
            env->Request(userConfirm, "api/staff/landing/confirm", "comment=landings_test1_confirm", propositionId);


            landingsGet = env->Request(userPropose, "api/staff/landing/get");

            bool findNewLandings = false;
            for (const auto& propose : landingsGet["landings"].GetArray())
            {
                if (propose["landing_id"].GetString() == "test_landing_test")
                {
                    findNewLandings = true;
                    break;
                }
            }
            UNIT_ASSERT(findNewLandings);
        }

        {
            NJson::TJsonValue propositionId;

            // propose
            jsonLanding["landing_id"] = "test_landing_test2";
            env->Request(userPropose, "api/staff/landing/propose", "comment=landings_test2_propose", jsonLanding);
            landingsGet = env->Request(userPropose, "api/staff/landing/get");

            for (const auto& propose : landingsGet["propositions"].GetArray())
            {
                if (propose["landing_id"].GetString() == "test_landing_test2")
                {
                    propositionId["proposition_ids"] = propose["proposition_id"].GetString();
                    break;
                }
            }
            // reject
            UNIT_ASSERT(propositionId.IsDefined());
            env->Request(userConfirm, "api/staff/landing/reject", "comment=landings_test2_reject", propositionId);


            landingsGet = env->Request(userPropose, "api/staff/landing/get");

            bool findNewLandings = false;

            for (const auto& propose : landingsGet["propositions"].GetArray())
            {
                if (propose["landing_id"].GetString() == "test_landing_test2")
                {
                    findNewLandings = true;
                    break;
                }
            }
            UNIT_ASSERT(!findNewLandings);


            findNewLandings = false;
            for (const auto& propose : landingsGet["landings"].GetArray())
            {
                if (propose["landing_id"].GetString() == "test_landing_test2")
                {
                    findNewLandings = true;
                    break;
                }
            }
            UNIT_ASSERT(!findNewLandings);
        }
    }
}
