#pragma once

#include <drive/telematics/api/client.h>

#include <rtline/api/graph/router/router.h>
#include <rtline/library/geometry/coord.h>
#include <rtline/library/scheduler/global.h>
#include <rtline/library/scheduler/registrator.h>

namespace NDrive {
    class TTripPlanner: public TGlobalScheduler::TScheduledItem<TTripPlanner> {
    public:
        TTripPlanner(const TString& imei, const TGeoCoord& startingPosition, const TGeoCoord& destination, TInstant start, TInstant finish, TAtomicSharedPtr<NDrive::TTelematicsApi> api, TAtomicSharedPtr<NGraph::TRouter> router);

        void Process(void* /*threadSpecificResource*/) override;
        THolder<IScheduledItem> GetNextScheduledItem(TInstant now) const override;

    private:
        const TString IMEI;
        const TGeoCoord StartingPosition;
        const TGeoCoord Destination;
        TInstant Start;
        TInstant Finish;

        TAtomicSharedPtr<NDrive::TTelematicsApi> Api;
        TAtomicSharedPtr<NGraph::TRouter> Router;
    };

    class TCarDriver {
    public:
        TCarDriver(TAtomicSharedPtr<NDrive::TTelematicsApi> api, TAtomicSharedPtr<NGraph::TRouter> router = nullptr);

        TGeoCoord GetCurrentPosition(const TString& imei);

        void PlanTrip(const TString& imei, const TGeoCoord& startingPosition, const TGeoCoord& destination, TInstant start, TInstant finish);
        void RelocateCar(const TString& imei, const TGeoCoord& destination);

        TString Name();

    private:
        TAtomicSharedPtr<NDrive::TTelematicsApi> Api;
        TAtomicSharedPtr<NGraph::TRouter> Router;
        NGlobalScheduler::TRegistrator GlobalSchedulerRegistrator;
    };
}
