#include "drivematics.h"

#include <drive/backend/data/leasing/company.h>

TString AddCompanyTag(const TString& userId, const NDrive::TServer& server) {
    auto name = RegisterCompanyTag(server);
    SendGlobalMessage<NDrive::TCacheRefreshMessage>();
    const auto& tagManager = server.GetDriveDatabase().GetTagsManager();
    auto tag = tagManager.GetTagsMeta().CreateTag(name);
    UNIT_ASSERT(tag);
    auto tx = tagManager.GetUserTags().BuildTx<NSQL::Writable>();
    auto added = tagManager.GetUserTags().AddTag(tag, USER_ROOT_DEFAULT, userId, &server, tx);
    UNIT_ASSERT(added);
    UNIT_ASSERT_VALUES_EQUAL(added->size(), 1);
    UNIT_ASSERT_VALUES_EQUAL(added->at(0).GetObjectId(), userId);
    UNIT_ASSERT(tx.Commit());
    return added->at(0).GetTagId();
}

TString RegisterCompanyTag(const NDrive::TServer& server) {
    auto organizationTag = MakeAtomicShared<NDrivematics::TUserOrganizationAffiliationTag::TDescription>();
    organizationTag->SetName("my company");
    organizationTag->SetType(NDrivematics::TUserOrganizationAffiliationTag::TypeName);
    organizationTag->SetCompanyName("Tri copyta");
    RegisterTag(server, organizationTag);
    return organizationTag->GetName();
}
