#pragma once

#include "helper.h"
#include "script.h"
#include <drive/backend/data/chargable.h>

class TTestEnvironment {
public:
    TTestEnvironment(const TString& databaseType = "SQLite");

    NDrive::TServerConfigGenerator* operator->() {
        return &ConfigGenerator;
    }

    void Build();

    NDrive::TServerConfigGenerator& GetConfigGenerator();
    TEnvironmentGenerator& GetEnvironmentGenerator();
    NDrive::TServerConfig& GetConfig();
    NDrive::TServerGuard& GetServer();
    NDrive::NTest::TRTContext& GetContext();
    TTelematicServerBuilder& GetTelematicServerBuilder();

    void Execute(NDrive::NTest::ITestAction& action);
    void Execute(NDrive::NTest::ITestAction&& action);

private:
    TAtomicSharedPtr<TTelematicServerBuilder> GetOrCreateTelematicServerBuilder();

private:
    NDrive::TServerConfigGenerator ConfigGenerator;
    TAtomicSharedPtr<TTelematicServerBuilder> TelematicServerBuilder;
    THolder<TEnvironmentGenerator> EnvironmentGenerator;
    THolder<NDrive::TServerConfig> Config;
    THolder<NDrive::TServerGuard> Server;
    THolder<NDrive::NTest::TRTContext> Context;
};

void AddRoleToUser(const NDrive::IServer& server, const TString& userId, const TString& roleId);
void RegisterAction(const NDrive::IServer& server, TUserAction::TPtr action, const TString& roleId = {});
void RegisterTag(const NDrive::IServer& server, TTagDescription::TPtr tagDescription);
void SetSetting(const NDrive::IServer& server, const TString& key, const TString& value);
TBillingSession::TBillingCompilation GetBillingCompilation(const NDrive::IServer& server, const TString& sessionId);
