#include "mock_notifier.h"

NDrive::INotifier::TResult::TPtr TMockNotifier::DoNotify(
        const TMessage& message, const TContext& context) const {
    ++CallsCount;
    for (auto&& r : context.GetRecipients()) {
        ProcessedMessages[r.GetUserId()].push_back(message);
    }
    return nullptr;
}

TMockNotifierConfig::TFactory::TRegistrator<TMockNotifierConfig> TMockNotifierConfig::Registrator("mock");

NDrive::INotifier::TPtr TMockNotifierConfig::Construct() const {
    return new TMockNotifier(*this);
}

TMockNotifier::TMockNotifier(const TMockNotifierConfig& config)
    : NDrive::INotifier(config)
{
}
