#pragma once
#include <drive/backend/abstract/notifier.h>

class TMockNotifierConfig: public NDrive::INotifierConfig {
private:
    static TFactory::TRegistrator<TMockNotifierConfig> Registrator;

public:
    NDrive::INotifier::TPtr Construct() const override;

private:
    void DoInit(const TYandexConfig::Section* /*section*/) override {}
    void DoToString(IOutputStream& /*os*/) const override {}
};

class TMockNotifier: public NDrive::INotifier, public TNonCopyable {
private:
    mutable THashMap<TString, TVector<TMessage>> ProcessedMessages;
    mutable ui32 CallsCount = 0;

public:
    TMockNotifier(const TMockNotifierConfig& config);
    const THashMap<TString, TVector<TMessage>>& GetProcessedMessages() const {
        return ProcessedMessages;
    }
    ui32 GetCallsCount() const { return CallsCount; }

    void DoStart(const IServerBase* /*server*/) override {}
    void DoStop() override {}

private:
    TResult::TPtr DoNotify(
        const TMessage& message,
        const TContext& context = Default<TContext>()) const override;
};
