#include "abstract.h"

#include <library/cpp/testing/unittest/registar.h>

namespace NDrive::NTest {

    TRTContext::TRTContext(NDrive::TServerConfigGenerator& configGenerator, NDrive::TServerGuard& server, TAtomicSharedPtr<TTelematicServerBuilder> telematicServerBuilder)
        : ConfigGenerator(configGenerator)
        , Server(server)
        , EGenerator(*Server)
        , TelematicServerBuilder(telematicServerBuilder ? telematicServerBuilder : MakeAtomicShared<TTelematicServerBuilder>())
        , Driver(TelematicServerBuilder->GetAPI())
    {
        if (!telematicServerBuilder) {
            TelematicServerBuilder->Run();
        }
        SetCar(OBJECT_IMEI_DEFAULT, OBJECT_ID_DEFAULT);
    }

    TScript::TScript(NDrive::TServerConfigGenerator& configGenerator, const TInstant start /*= Now()*/)
        : Start(start)
        , ConfigGenerator(configGenerator)
    {
        CurrentTS = Start;
        TServerConfigConstructorParams params(ConfigGenerator.GetString().data());
        Config.Reset(new NDrive::TServerConfig(params));
        Server.Reset(new NDrive::TServerGuard(*Config));
    }

    bool TScript::Execute() {
        TRTContext Context(ConfigGenerator, *Server);
        ui32 idx = 0;
        for (auto&& i : Actions) {
            for (auto&& e : i.second) {
                INFO_LOG << LogColorGreen << "Start item: " << ": " << ++idx << " : " << LogColorNo << Endl;
                try {
                    e->Execute(Context);
                    INFO_LOG << LogColorGreen << "Finished item: " << ": " << idx << " : " << LogColorNo << Endl;
                } catch (NUnitTest::TAssertException& assertEx) {
                    ythrow assertEx;
                } catch (const std::exception& e) {
                    ERROR_LOG << LogColorRed << "Failed item: " << ": " << idx << " : " << FormatExc(e) << LogColorNo << Endl;
                    return false;
                }
            }
        }
        return true;
    }
}
