#include "billing.h"

namespace NDrive::NTest {
    TAPIAction::TFactory::TRegistrator<TLinkAccount> TLinkAccount::Registrator("link_account");

    void TLinkAccount::DoExecute(TRTContext& context) {
        NJson::TJsonValue post;
        post["user_id"] = UserId;
        post["name"] = AccountName;
        post["action"] = "link";
        post["active_flag"] = true;
        if (Promocode) {
            post["promocode"] = Promocode;
        }
        NJson::TJsonValue reply = SendRequest(context, "/api/staff/billing/accounts/link", post);
        UNIT_ASSERT(!reply.IsNull());
        ui32 accountId = 0;
        for (auto&& acc : reply["account_ids"].GetArray()) {
            accountId = acc.GetInteger();
        }
        UNIT_ASSERT(!!accountId);
    }

    TString TLinkAccount::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/billing/accounts/link>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: link_account" << Endl;
        ss << "</api/staff/billing/accounts/link>" << Endl;
        ss << "<api/staff/billing/accounts/activate>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: activate_account" << Endl;
        ss << "</api/staff/billing/accounts/activate>" << Endl;
        return ss.Str();
    }

    TAPIAction::TFactory::TRegistrator<TCreateAccount> TCreateAccount::Registrator("create_account");

    void TCreateAccount::DoExecute(TRTContext& context) {
        NJson::TJsonValue post;
        post["type"] = ::ToString(Type);
        post["name"] = Name;
        post["hard_limit"] = NDrive::NBilling::AccountLimit;
        post["soft_limit"] = NDrive::NBilling::AccountLimit;
        post["meta"]["data_type"] = ::ToString(DataType);
        post["meta"]["hr_name"] = HRName;
        post["meta"]["selectable"] = true;
        post["meta"]["refresh_policy"] = ::ToString(RefreshPolicy);
        post["meta"]["offers_filter"] = JoinVectorIntoString(Tags, ",");
        NJson::TJsonValue reply = SendRequest(context, "/api/staff/billing/accounts/update", post);
        UNIT_ASSERT(!reply.IsNull());
    }

    TString TCreateAccount::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/billing/accounts/update>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: update_common_account" << Endl;
        ss << "</api/staff/billing/accounts/update>" << Endl;
        return ss.Str();
    }

    void TBillingEmptyCardsReply::DoExecute(TRTContext& context) {
        auto emptyCardsReply = "{\"status\": \"success\", \"bound_payment_methods\" : []}";
        context.GetEGenerator().GetBillingMock().SetReply(emptyCardsReply);
    }

    void TRunBillingCycle::DoExecute(TRTContext& context) {
        auto &billingManager = context.GetServer()->GetDriveAPI()->GetBillingManager();
        billingManager.WaitBillingCycle(15, 1);
        billingManager.WaitBillingCycle(15, 1);
    }
}
