#pragma once

#include "abstract.h"

namespace NDrive::NTest {

    class TCreateAccount : public TAPIAction {
        R_READONLY(TString, Name);
        R_READONLY(TString, HRName, "Test");
        R_FIELD(NDrive::NBilling::EAccount, Type, NDrive::NBilling::EAccount::Wallet);
        R_FIELD(NDrive::NBilling::EWalletDataType, DataType, NDrive::NBilling::EWalletDataType::Simple);
        R_FIELD(NDrive::NBilling::TRefreshSchedule::EPolicy, RefreshPolicy, NDrive::NBilling::TRefreshSchedule::EPolicy::None);
        R_FIELD(TVector<TString>, Tags, {});
    private:
        using TBase = TAPIAction;
        static TFactory::TRegistrator<TCreateAccount> Registrator;
    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        TCreateAccount(const TInstant startInstant, const TString& name)
            : TBase(startInstant)
            , Name(name)
            , HRName(name)
        {}

        using TBase::TBase;

        virtual TString GetProcessorConfiguration() const override;
    };

    class TLinkAccount : public TAPIAction {
        R_READONLY(TString, AccountName);
        R_FIELD(TString, UserId, USER_ID_DEFAULT);
        R_FIELD(TString, Promocode);

    private:
        using TBase = TAPIAction;
        static TFactory::TRegistrator<TLinkAccount> Registrator;
    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;

        TLinkAccount(const TInstant startInstant, const TString& accountName)
            : TBase(startInstant)
            , AccountName(accountName)
        {}

        virtual TString GetProcessorConfiguration() const override;
    };

    class TBillingEmptyCardsReply: public ITestAction {
    public:
        using ITestAction::ITestAction;
        virtual void DoExecute(TRTContext& context) override;
    };

    class TRunBillingCycle: public ITestAction {
    public:
        using ITestAction::ITestAction;
        virtual void DoExecute(TRTContext& context) override;
    };
}
