#include "car.h"
#include "library/cpp/json/writer/json_value.h"


namespace NDrive::NTest {

    TAPIAction::TFactory::TRegistrator<TModifyCarModel> TModifyCarModel::Registrator("modify_car_model");

    TString TModifyCarModel::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/model/info>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: car_models_info" << Endl;
        ss << "</api/staff/model/info>" << Endl;
        return ss.Str();
    }

    void TModifyCarModel::DoExecute(TRTContext& context) {
        UNIT_ASSERT(GetCar(context).Id);
        TString request = "/api/staff/model/info";
        NJson::TJsonValue payload = NJson::TMapBuilder("code", Model)("name", Name)("manufacturer", Manufacturer);
        NJson::InsertField(payload, "first_maintenance_mileage", FirstMaintenanceMileage);
        NJson::InsertField(payload, "maintenance_mileage", MaintenanceMileage);
        NJson::InsertField(payload, "intermediate_maintenance_mileage", IntermediateMaintenanceMileage);
        NJson::InsertField(payload, "maintenance_period", MaintenancePeriod);
        NJson::TJsonValue reply = SendRequest(context, request, payload);
        UNIT_ASSERT(GetExpectOK() == !reply.IsNull());
    }

    TAPIAction::TFactory::TRegistrator<TModifyCarRegistryData> TModifyCarRegistryData::Registrator("modify_car_registry_data");

    TString TModifyCarRegistryData::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/car/batch-upload>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: car_registry_update" << Endl;
        ss << "</api/staff/car/batch-upload>" << Endl;
        return ss.Str();
    }

    void TModifyCarRegistryData::DoExecute(TRTContext& context) {
        UNIT_ASSERT(GetCar(context).Vin);
        TString request = "/api/staff/car/batch-upload";
        NJson::TJsonValue carData;
        NJson::InsertField(carData, "vin", GetCar(context).Vin);
        for (auto&& [key, value] : Values) {
            NJson::InsertField(carData, key, value);
        }
        NJson::TJsonValue payload = NJson::JSON_ARRAY;
        payload.AppendValue(carData);
        NJson::TJsonValue reply = SendRequest(context, request, NJson::TMapBuilder("cars", payload));
        UNIT_ASSERT(GetExpectOK() == !reply.IsNull());
    }
}
