#include "chat.h"

namespace NDrive::NTest {
    void THasChat::DoExecute(TRTContext& context) {
        auto chatsList = context.GetConfigGenerator().GetChatsList(context.GetUserId(), context.GetServer().Get());
        if (ChatId) {
            ui32 found = 0;
            for (auto&& chat : chatsList["chats"].GetArray()) {
                TString chatId = chat["id"].GetString();
                TString topic;
                IChatRobotImpl::ParseTopicLink(chatId, chatId, topic);
                if (chatId == ChatId) {
                    ++found;
                }
            }
            UNIT_ASSERT_VALUES_EQUAL(found > 0, GetExpectOK());
            if (ChatCount) {
                UNIT_ASSERT_C((found == ChatCount.GetRef()) == GetExpectOK(), "Found " + ToString(chatsList["chats"].GetArray().size()) + " chats, expected: " + ToString(ChatCount.GetRef()));
            }
        } else if (ChatCount) {
            UNIT_ASSERT_C((chatsList["chats"].GetArray().size() == ChatCount.GetRef()) == GetExpectOK(), "Found " + ToString(chatsList["chats"].GetArray().size()) + " chats, expected: " + ToString(ChatCount.GetRef()));
        }
    }

    void TCommitChatAction::DoExecute(TRTContext& context) {
        UNIT_ASSERT(context.GetConfigGenerator().CommitChatAction(context.GetUserId(), ChatId, Message, Attachments));
    }

    void TCheckChatMessages::DoExecute(TRTContext& context) {
        auto messagesJson = context.GetConfigGenerator().GetChatMessages(context.GetUserId(), ChatId, OperatorId);
        if (MessageCount) {
            UNIT_ASSERT_C((messagesJson["messages"].GetArray().size() == MessageCount.GetRef()) == GetExpectOK(), ToString(messagesJson["messages"].GetArray().size()) + " expected: " + ToString(MessageCount.GetRef()));
        }
        for (const auto& [ind, text] : MessageValues) {
            UNIT_ASSERT_C(ind < messagesJson["messages"].GetArray().size(), "array index out of bounds: " + ToString(ind));
            UNIT_ASSERT_VALUES_EQUAL(messagesJson["messages"].GetArray()[ind]["text"], text);
        }
        if (ExpectedActionType) {
            UNIT_ASSERT_VALUES_EQUAL(messagesJson["expected_action"]["type"], ExpectedActionType);
        }
    }

    void TCheckChatUnreads::DoExecute(TRTContext& context) {
        TString request = "/api/chat/history/unread";
        if (ChatId) {
            request = request + "?" + ChatId;
        }
        auto response = SendRequest(context, request);
        Checker(response, context);
    }

    void TSendMessage::DoExecute(TRTContext& context) {
        NJson::TJsonValue post;
        if (RequestJson) {
            post = RequestJson.GetRef();
        } else {
            post["message"] = MessageText;
        }
        NNeh::THttpRequest request;
        TString userId = MessageUserId ? MessageUserId : context.GetUserId();
        NUtil::THttpReply result = GetSendReply(context, "/api/staff/chat/message", post, "chat_id=" + ChatId + "&user_id=" + userId);
        NJson::TJsonValue resultReport = NJson::JSON_MAP;
        UNIT_ASSERT_C((result.Code() == 200) == GetExpectOK(), "Code: " + ToString(result.Code()));
        UNIT_ASSERT_C(NJson::ReadJsonFastTree(result.Content(), &resultReport), result.Content());
        if (Checker) {
            Checker.GetRef()(resultReport, context);
        }
    }

    void TCloseChat::DoExecute(TRTContext& context) {
        TString userId = UserId ? UserId : context.GetUserId();
        if (TagName) {
            TVector<TDBTag> dbTags;
            {
                auto session = context.GetServer()->GetDriveAPI()->template BuildTx<NSQL::Writable>();
                UNIT_ASSERT(context.GetServer()->GetDriveAPI()->GetTagsManager().GetUserTags().RestoreTags({ userId }, {TagName}, dbTags, session));
            }
            for (auto&& tag : dbTags) {
                TString additionalParams = IsExternal ? "&is_external=true" : "";
                UNIT_ASSERT_VALUES_EQUAL(context.GetConfigGenerator().CloseChat(tag.GetTagId(), userId, additionalParams), GetExpectOK());
            }
        }
        if (TagId) {
            UNIT_ASSERT_VALUES_EQUAL(context.GetConfigGenerator().CloseChat(TagId, userId), GetExpectOK());
        }
    }

    void TDeferChat::DoExecute(TRTContext& context) {
        TString userId = UserId ? UserId : context.GetUserId();
        TString operatorId = OperatorId ? OperatorId : USER_ROOT_DEFAULT;
        if (TagName) {
            TVector<TDBTag> dbTags;
            {
                auto session = context.GetServer()->GetDriveAPI()->template BuildTx<NSQL::Writable>();
                UNIT_ASSERT(context.GetServer()->GetDriveAPI()->GetTagsManager().GetUserTags().RestoreTags({ userId }, { TagName }, dbTags, session));
            }
            for (auto&& tag : dbTags) {
                UNIT_ASSERT_VALUES_EQUAL(context.GetConfigGenerator().DeferRequest(tag.GetTagId(), operatorId, DeferUntil, Message, Comment), GetExpectOK());
            }
        }
        if (TagId) {
            UNIT_ASSERT_VALUES_EQUAL(context.GetConfigGenerator().DeferRequest(TagId, operatorId, DeferUntil, Message, Comment), GetExpectOK());
        }
    }
};
