#pragma once

#include "abstract.h"

namespace NDrive::NTest {
    class THasChat: public ITestAction {
    private:
        using TBase = ITestAction;

        R_FIELD(TString, ChatId);
        R_OPTIONAL(ui32, ChatCount);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        THasChat(const TInstant startInstant)
            : TBase(startInstant)
        {
        }
    };

    class TCheckChatMessages: public ITestAction {
    private:
        using TBase = ITestAction;
        using MessageValuesMap = TMap<ui32, TString>;
        R_FIELD(MessageValuesMap, MessageValues);
        R_FIELD(TString, ChatId);
        R_FIELD(TString, OperatorId);
        R_FIELD(TString, ExpectedActionType);
        R_OPTIONAL(ui32, MessageCount);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        TCheckChatMessages(const TInstant startInstant)
            : TBase(startInstant)
        {
        }
    };

    class TCommitChatAction: public ITestAction {
    private:
        using TBase = ITestAction;

        R_FIELD(TString, ChatId);
        R_FIELD(TString, Message);
        R_FIELD(TVector<TString>, Attachments);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        TCommitChatAction(const TInstant startInstant, const TString& chatId, const TString& message)
            : TBase(startInstant)
            , ChatId(chatId)
            , Message(message)
        {
        }
    };

    class TCheckChatUnreads: public TAPIAction {
    public:
        using TChecker = std::function<void(const NJson::TJsonValue& response, TRTContext& context)>;

    private:
        using TBase = TAPIAction;
        R_FIELD(TString, ChatId);
        R_FIELD(TChecker, Checker);

        static TFactory::TRegistrator<TCheckChatUnreads> Registrator;

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;

        TCheckChatUnreads(const TInstant startInstant)
            : TBase(startInstant)
        {
        }

        TString GetProcessorConfiguration() const override {
            TStringStream ss;
            ss << "<api/chat/history/unread>" << Endl;
            ss << "    AuthModuleName: fake" << Endl;
            ss << "    ProcessorType: robot_chat_unreads" << Endl;
            ss << "</api/chat/history/unread>" << Endl;
            return ss.Str();
        }
    };

    class TSendMessage: public TAPIAction {
    public:
        using TChecker = std::function<void(const NJson::TJsonValue& response, TRTContext& context)>;

    private:
        using TBase = TAPIAction;
        R_FIELD(TString, MessageText);
        R_FIELD(TString, ChatId);
        R_FIELD(TString, MessageUserId);
        R_OPTIONAL(NJson::TJsonValue, RequestJson);
        R_OPTIONAL(TChecker, Checker);

        static TFactory::TRegistrator<TSendMessage> Registrator;

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;

        TSendMessage(const TInstant startInstant)
            : TBase(startInstant)
        {
        }

        TString GetProcessorConfiguration() const override {
            TStringStream ss;
            ss << "<api/staff/chat/message>" << Endl;
            ss << "    AuthModuleName: fake" << Endl;
            ss << "    ProcessorType: robot_chat_action" << Endl;
            ss << "</api/staff/chat/message>" << Endl;
            return ss.Str();
        }
    };

    class TCloseChat: public ITestAction {
    private:
        using TBase = ITestAction;

        R_FIELD(TString, UserId);
        R_FIELD(TString, TagId);
        R_FIELD(TString, TagName);
        R_FIELD(bool, IsExternal, false);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        TCloseChat(const TInstant startInstant)
            : TBase(startInstant)
        {
        }
    };

    class TDeferChat: public ITestAction {
    private:
        using TBase = ITestAction;

        R_FIELD(TString, UserId);
        R_FIELD(TString, OperatorId);
        R_FIELD(TString, TagId);
        R_FIELD(TString, TagName);
        R_FIELD(TString, Comment);
        R_FIELD(TString, Message);
        R_FIELD(TMaybe<TInstant>, DeferUntil);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        TDeferChat(const TInstant startInstant)
            : TBase(startInstant)
        {
        }
    };
};
