#include "roles.h"

#include <drive/backend/roles/manager.h>

namespace NDrive::NTest {
    TAPIAction::TFactory::TRegistrator<TAddAdmActions> TAddAdmActions::Registrator("add_action");

    void TAddAdmActions::DoExecute(TRTContext& context) {
        NJson::TJsonValue reply = SendRequest(context, "/api/staff/actions/list");
        UNIT_ASSERT(reply.Has("report") && reply["report"].IsArray());

        NJson::TJsonValue updateRequest(NJson::JSON_NULL);
        for (auto&& actionJson : reply["report"].GetArray()) {
            if (actionJson["action_id"] == "adm_actions_default") {
                updateRequest = actionJson;

                TSet<TString> actionsList;
                UNIT_ASSERT(updateRequest["action_meta"]["adm_actions"].IsArray());
                updateRequest["action_meta"]["adm_actions"] = NJson::TJsonValue(NJson::JSON_ARRAY);
                updateRequest["action_meta"]["adm_actions"].AppendValue(::ToString(Action));
                actionsList.insert(::ToString(Action));
                for (auto&& item : actionJson["action_meta"]["adm_actions"].GetArray()) {
                    if (actionsList.insert(item.GetString()).second) {
                        updateRequest["action_meta"]["adm_actions"].AppendValue(item.GetString());
                    }
                }

                TSet<TString> eList;
                UNIT_ASSERT(updateRequest["action_meta"]["adm_entities"].IsArray());
                updateRequest["action_meta"]["adm_entities"] = NJson::TJsonValue(NJson::JSON_ARRAY);
                updateRequest["action_meta"]["adm_entities"].AppendValue(::ToString(Entity));
                eList.insert(::ToString(Entity));
                for (auto&& item : actionJson["action_meta"]["adm_entities"].GetArray()) {
                    if (eList.insert(item.GetString()).second) {
                        updateRequest["action_meta"]["adm_entities"].AppendValue(item.GetString());
                    }
                }
            }
        }
        UNIT_ASSERT(!updateRequest.IsNull());
        INFO_LOG << updateRequest.GetStringRobust() << Endl;
        NJson::TJsonValue replyAdd = SendRequest(context, "/api/staff/actions/add", updateRequest);
        UNIT_ASSERT(!replyAdd.IsNull());
        SendGlobalMessage<NDrive::TCacheRefreshMessage>();
    }

    TString TAddAdmActions::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/actions/add>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: manage_action/add" << Endl;
        ss << "</api/staff/actions/add>" << Endl;
        ss << "<api/staff/actions/list>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: manage_action/list" << Endl;
        ss << "</api/staff/actions/list>" << Endl;
        return ss.Str();
    }

    TString TAddRole::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/staff/car/tag/add>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: car_tags/add" << Endl;
        ss << "</api/staff/car/tag/add>" << Endl;
        ss << "<api/yandex/sessions/current>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: current_session" << Endl;
        ss << "</api/yandex/sessions/current>" << Endl;
        return ss.Str();
    }

    void TAddRole::DoExecute(TRTContext& context) {
        auto server = context.GetServer();
        auto session = server->GetDriveAPI()->template BuildTx<NSQL::Writable>();
        TUserRole userRole;
        userRole.SetRoleId(RoleId).SetUserId(UserId).SetActive(true);

        const NJson::TJsonValue roleJson = userRole.SerializeToTableRecord().SerializeToJson();
        UNIT_ASSERT(!SendRequest(context, "/api/staff/user_roles/add", roleJson, "").IsNull());
    }

    void TUpsertAction::DoExecute(TRTContext& context) {
        auto session = context.GetDriveAPI().BuildTx<NSQL::Writable>();
        UNIT_ASSERT(context.GetDriveAPI().GetRolesManager()->GetActionsDB().ForceUpsert(Action, USER_ROOT_DEFAULT, session) && session.Commit());
    }
}
