#pragma once

#include "abstract.h"

namespace NDrive::NTest {

    class TAddAdmActions : public TAPIAction {
        R_READONLY(TAdministrativeAction::EAction, Action, TAdministrativeAction::EAction::Observe);
        R_READONLY(TAdministrativeAction::EEntity, Entity, TAdministrativeAction::EEntity::Wallet);
    private:
        using TBase = TAPIAction;
        static TFactory::TRegistrator<TAddAdmActions> Registrator;
    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;

        TAddAdmActions(const TInstant startInstant, TAdministrativeAction::EAction action, TAdministrativeAction::EEntity entity)
            : TBase(startInstant)
            , Action(action)
            , Entity(entity)
        {}

        virtual TString GetProcessorConfiguration() const override;
    };

    class TAddRole: public TAPIAction {
    private:
        using TBase = TAPIAction;
        R_FIELD(TString, UserId, USER_ID_DEFAULT);
        R_FIELD(TString, RoleId);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;

        virtual TString GetProcessorConfiguration() const override;
    };

    class TUpsertAction: public ITestAction {
        using TBase = ITestAction;

    private:
        R_FIELD(TUserAction::TPtr, Action);

    protected:
        virtual void DoExecute(TRTContext& context) override;

    public:
        using TBase::TBase;
    };
}
