#include "session.h"

namespace NDrive::NTest {
    TAPIAction::TFactory::TRegistrator<TCreateAndBookOffer> TCreateAndBookOffer::Registrator("create_and_book");
    TAPIAction::TFactory::TRegistrator<TBookDefault> TBookDefault::Registrator("book_default");
    TAPIAction::TFactory::TRegistrator<TCreateAndSwitchOffer> TCreateAndSwitchOffer::Registrator("create_and_switch");

    void TCreateAndBookOffer::DoExecute(TRTContext& context) {
        TString carId = GetCar(context).Id;
        TString cgiData("car_id=" + carId);
        if (!!UserDestination) {
            TString coord = UserDestination->ToString();
            UrlEscape(coord);
            cgiData += TString("&user_destination=") + coord;
        }
        if (!!AccountName) {
            cgiData += TString("&account_id=") + AccountName;
        }
        if (!!OfferName) {
            cgiData += TString("&offer_name=") + *OfferName;
        }
        if (WithHints) {
            cgiData += TString("&with_hints=1");
        }
        TInstant timeStart = Now();
        bool found = false;
        do {
            NJson::TJsonValue report = SendRequest(context, "/api/yandex/offers/create", PostJson, cgiData);
            if (OffersCount) {
                UNIT_ASSERT_VALUES_EQUAL(*OffersCount, report["offers"].GetArraySafe().size());
            }
            if (report["offers"].IsArray() && report["offers"].GetArraySafe().size() > 1) {
                TSet<TString> offerIdsChecker;
                for (auto&& i : report["offers"].GetArraySafe()) {
                    UNIT_ASSERT(offerIdsChecker.emplace(i["offer_id"].GetString()).second);
                }
            }
            INFO_LOG << report << Endl;
            const TString offerId = report["offers"][0]["offer_id"].GetString();
            if (!offerId) {
                if (GetExpectOK()) {
                    Sleep(TDuration::MilliSeconds(300));
                    continue;
                }
                return;
            }

            for (auto&& i : report["offers"].GetArraySafe()) {
                if ((!OfferType || i["type"].GetStringSafe() == *OfferType) && (!OfferName || i["name"].GetStringSafe() == *OfferName)) {
                    const TString offerId = i["offer_id"].GetString();
                    if (context.GetConfigGenerator().BookOffer(offerId, HasUserId() ? GetUserIdUnsafe() : context.GetUserId(), context.GetDeviceIdPtr(), GetPayloadPatch())) {
                        if (!IsFutures) {
                            UNIT_ASSERT(GetExpectOK());
                        }
                    } else {
                        if (!GetExpectOK()) {
                            return;
                        }
                        UNIT_ASSERT(IsFutures || !GetExpectOK());
                        continue;
                    }
                    if (IsFutures && !i.Has("car_waiting_duration")) {
                        continue;
                    }
                    context.SetOfferJson(i, GetNamedCar());
                    found = true;
                    break;
                }
            }
        } while (Now() - timeStart < WaitingDuration && (IsFutures || IsOfferWaiting) && !found);

        if (GetIsFutures()) {
            UNIT_ASSERT_VALUES_EQUAL(GetExpectOK(), found);
        } else {
            if (GetExpectOK()) {
                UNIT_ASSERT(found);
                UNIT_ASSERT(context.GetConfigGenerator().WaitStatus(carId, "old_state_reservation", *context.GetServer()));
            } else {
                UNIT_ASSERT(!found);
            }
        }
    }

    void TCreateAndCheckOffer::DoExecute(TRTContext& context) {
        TString carId = GetCar(context).Id;
        TString cgiData("car_id=" + carId);
        if (!!UserDestination) {
            TString coord = UserDestination->ToString();
            UrlEscape(coord);
            cgiData += TString("&user_destination=") + coord;
        }
        if (!!AccountName) {
            cgiData += TString("&account_id=") + AccountName;
        }
        if (!!OfferName) {
            cgiData += TString("&offer_name=") + *OfferName;
        }
        TInstant timeStart = Now();
        bool found = false;
        do {
            NJson::TJsonValue report = SendRequest(context, "/api/yandex/offers/create", NJson::JSON_NULL, cgiData);
            const TString offerId = report["offers"][0]["offer_id"].GetString();
            if (!offerId) {
                if (!IsFutures) {
                    UNIT_ASSERT(!GetExpectOK());
                } else {
                    if (!GetExpectOK()) {
                        return;
                    }
                    continue;
                }
                return;
            }
            INFO_LOG << report << Endl;

            for (auto&& i : report["offers"].GetArraySafe()) {
                if ((!OfferType || i["type"].GetStringSafe() == *OfferType) && (!OfferName || i["name"].GetStringSafe() == *OfferName)) {
                    const TString offerId = i["offer_id"].GetString();
                    if (!!Checker) {
                        (*Checker)(i, context);
                    }
                    found = true;
                    if (!OnlyCheck) {
                        context.SetOfferJson(i, GetNamedCar());
                        break;
                    }
                }
            }
        } while (Now() - timeStart < FuturesWaitingDuration && IsFutures && !found);

        if (GetIsFutures()) {
            UNIT_ASSERT_VALUES_EQUAL(GetExpectOK(), found);
        } else {
            if (GetExpectOK()) {
                UNIT_ASSERT(found);
            } else {
                UNIT_ASSERT(!found);
            }
        }
    }

    void TCreateAndSwitchOffer::DoExecute(TRTContext& context) {
        TString carId = GetCar(context).Id;
        TString cgiData("car_id=" + carId);
        if (!!UserDestination) {
            TString coord = UserDestination->ToString();
            UrlEscape(coord);
            cgiData += TString("&user_destination=") + coord;
        }
        if (!!OfferName) {
            cgiData += TString("&offer_name=") + *OfferName;
        }
        if (!!AccountName) {
            cgiData += TString("&account_id=") + AccountName;
        }
        NJson::TJsonValue report;
        const TInstant start = Now();
        TString offerId;
        do {
            NJson::TJsonValue report = SendRequest(context, "/api/yandex/offers/create", NJson::JSON_NULL, cgiData);
            if (report["offers"].IsArray() != GetExpectOK()) {
                if (GetExpectOK()) {
                    Sleep(TDuration::Seconds(5));
                    continue;
                } else {
                    break;
                }
            }
            INFO_LOG << report << Endl;

            for (auto&& i : report["offers"].GetArraySafe()) {
                if ((!OfferType || i["type"].GetStringSafe() == *OfferType) && (!OfferName || i["name"].GetStringSafe() == *OfferName)) {
                    offerId = i["offer_id"].GetString();
                    context.SetOfferJson(i, GetNamedCar());
                    break;
                }
            }
            if (!!offerId != GetExpectOK()) {
                Sleep(TDuration::Seconds(5));
                continue;
            } else {
                break;
            }
        } while (Now() - start < WaitingDuration);

        UNIT_ASSERT_VALUES_EQUAL(!!offerId, GetExpectOK());
        UNIT_ASSERT_VALUES_EQUAL(context.GetConfigGenerator().SwitchOffer(offerId, HasUserId() ? GetUserIdUnsafe() : context.GetUserId(), context.GetDeviceIdPtr()), GetExpectOK());
    }

    TString TCreateAndBookOffer::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/yandex/offers/create>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: create_offers" << Endl;
        ss << "</api/yandex/offers/create>" << Endl;
        return ss.Str();
    }

    void TBookDefault::DoExecute(TRTContext& context) {
        NJson::TJsonValue post;
        TString carId = GetCar(context).Id;
        TString cgiData("car_id=" + carId);
        if (!!AccountName) {
            cgiData += TString("&account_id=") + AccountName;
        }
        NJson::TJsonValue reply = SendRequest(context, "service_app/my/offers/book_default", post, cgiData);
        UNIT_ASSERT(!reply.IsNull());
    }

    TString TBookDefault::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<service_app/my/offers/book_default>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: offer_book" << Endl;
        ss << "    OfferPrefix: standart_" << Endl;
        ss << "</service_app/my/offers/book_default>" << Endl;
        return ss.Str();
    }

    TString TCreateAndSwitchOffer::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/yandex/offers/switch>" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "    ProcessorType: switch_offer" << Endl;
        ss << "</api/yandex/offers/switch>" << Endl;
        return ss.Str();
    }

    void TEvolution::DoExecute(TRTContext& context) {
        TString carId = GetCar(context).Id;
        if (!!CarPosition) {
            context.RelocateCar(GetCarPositionUnsafe(), GetCar(context));
        }
        auto sessionId = UseSessionId ? context.GetOfferId(GetNamedCar()) : TString();
        auto evResult = context.GetConfigGenerator().EvolveTag(GetState(), GetActionUserId() ? GetActionUserId() : context.GetUserId(), TDuration::Seconds(120), GetAlertLandingId(), EvolutionMode, GetInitialPost(), sessionId);
        UNIT_ASSERT_VALUES_EQUAL(evResult, GetExpectOK());
        if (CheckStatus) {
            UNIT_ASSERT(context.GetConfigGenerator().WaitStatus(carId, GetWaitingStatus(), *context.GetServer()));
        }
        SendGlobalMessage<NDrive::TCacheRefreshMessage>();
    }

    void TEvolution::ChangeState(TString& state) const {
        if (state) {
            state += "-";
        }
        state += GetState();
        if (!GetExpectOK()) {
            state += "-failed";
        }
    }
    void TSwitchOffer::DoExecute(TRTContext& context) {
        TString cgiData;
        if (!!OfferId) {
            cgiData = "offer_id=" + *OfferId;
        }
        NJson::TJsonValue report = SendRequest(context, "/api/yandex/offers/switch", NJson::JSON_NULL, cgiData);
        if (IsExpectOK()) {
            UNIT_ASSERT(report.IsDefined());
            auto offerId = report["offer_id"].GetString();
            UNIT_ASSERT(offerId);
            context.SetOfferJson(report, GetNamedCar());
        } else {
            UNIT_ASSERT(!report.IsDefined());
        }
    }

    TString TSwitchOffer::GetProcessorConfiguration() const {
        TStringStream ss;
        ss << "<api/yandex/offers/create>" << Endl;
        ss << "    ProcessorType: switch_offers" << Endl;
        ss << "    AuthModuleName: fake" << Endl;
        ss << "</api/yandex/offers/create>" << Endl;
        return ss.Str();
    }
}
