#include "signalq.h"

#include <drive/backend/processors/leasing/get_signals.h>
#include <drive/backend/processors/signalq/processor.h>
#include <drive/backend/signalq/signals/helpers.h>
#include <drive/backend/signalq/signals/tag.h>

void RegisterSignalqSessionMetadata(const NDrive::IServer& server) {
    auto enableSignalqSessionsTag = MakeAtomicShared<TTagDescription>();
    enableSignalqSessionsTag->SetName("enable_signalq_sessions");
    enableSignalqSessionsTag->SetType(TDeviceTagRecord::TypeName);
    RegisterTag(server, enableSignalqSessionsTag);
    SetSetting(server, "signalq.signalq_session.enable", "true");
    SetSetting(server, "signalq.signalq_session.evolve_to_riding", "true");
    SetSetting(server, "signalq.signalq_session.offer_name", "signalq_sessions");
    SetSetting(server, "signalq.signalq_session.tag", enableSignalqSessionsTag->GetName());
    SetSetting(server, "signalq.signalq_events.shutdown_tag_name", "shutdown");
    SetSetting(server, "signalq.signalq_status.actual_status_gap", "5m");

    auto enableSignalqEvents = MakeAtomicShared<TTagDescription>();
    enableSignalqEvents->SetName("enable_signalq_events");
    enableSignalqEvents->SetType(TDeviceTagRecord::TypeName);
    RegisterTag(server, enableSignalqEvents);
    SetSetting(server, "signalq.signalq_events.enable_tag", enableSignalqEvents->GetName());
    SetSetting(server, "signalq.signalq_events.actual_ride_gap", "5m");
    SetSetting(server, "signalq.signalq_events.trace_tag", "signalq_event_trace_tag");

    TVector<NDrivematics::TSignalDescription> signalqSignalsDescriptions;
    signalqSignalsDescriptions.emplace_back()
        .SetType("bad_camera_pose")
        .SetName("bad_camera_pose_tag")
        .SetDisplayName("Плохо с камерой")
        .SetPriority(NDrivematics::ISignalConfiguration::ESignalPriority::Normal)
        .SetSource(NDrivematics::TSignalDescription::ESource::SignalQ);
    signalqSignalsDescriptions.emplace_back()
        .SetType("tired")
        .SetName("tired_tag2")
        .SetDisplayName("Водитель устал")
        .SetPriority(NDrivematics::ISignalConfiguration::ESignalPriority::Normal)
        .SetSource(NDrivematics::TSignalDescription::ESource::SignalQ);
    SetSetting(server, SignalqSignalsDescriptionSettingName, NJson::ToJson(NJson::TJsonValue{NJson::TMapBuilder("descriptions", NJson::ToJson(signalqSignalsDescriptions))}).GetStringRobust());
    for (const auto& signalqSignalDesc : signalqSignalsDescriptions) {
        TTagDescription::TPtr tagDescription = new TTagDescription();
        tagDescription->SetName(signalqSignalDesc.GetName());
        tagDescription->SetType(TSignalqEventTraceTag::TypeName);
        RegisterTag(server, tagDescription);
    }

    TTagDescription::TPtr tagDescription = new TTagDescription();
    tagDescription->SetName("signalq_deleted_event_tag");
    tagDescription->SetType(TSignalqEventTraceTag::TypeName);
    RegisterTag(server, tagDescription);
}
