LIBRARY()

OWNER(g:drive-backend)

PEERDIR(
    drive/backend/abstract
    drive/backend/actions
    drive/backend/auth/fake
    drive/backend/auth/yang
    drive/backend/base
    drive/backend/chat_robots
    drive/backend/data
    drive/backend/data/alerts
    drive/backend/database
    drive/backend/database/drive
    drive/backend/database/history
    drive/backend/documents_verification
    drive/backend/fueling_manager/ut/library
    drive/backend/localization
    drive/backend/offers
    drive/backend/offers/actions
    drive/backend/offers/price
    drive/backend/processors
    drive/backend/processors/car_scanner
    drive/backend/processors/car_scanner/proto
    drive/backend/registrar
    drive/backend/rt_background/future_book
    drive/backend/rt_background/rt_factors
    drive/backend/rt_background/radar
    drive/backend/server/library
    drive/backend/signalq/signals
    drive/backend/tags
    drive/telematics/api
    drive/telematics/server/library
    drive/telematics/server/pusher
    drive/telematics/server/tasks
    drive/telematics/server/ut/library
    drive/tests/library
    maps/libs/local_postgres
    rtline/library/async_proxy/ut/helper
    rtline/library/storage/sqlite
    rtline/util/types
)

IF (NOT OS_WINDOWS)
    PEERDIR(
        rtline/library/storage/postgres
    )
ENDIF()

GENERATE_ENUM_SERIALIZATION(helper.h)

SRCS(
    car_driver.cpp
    drivematics.cpp
    helper.cpp
    helper2.cpp
    mock_notifier.cpp
    script.cpp
    signalq.cpp
)

END()
