#include <drive/backend/ut/library/helper.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(DbOperationsPostgresSuite) {
    Y_UNIT_TEST(Upsert) {
        NDrive::TServerConfigGenerator configGenerator("LocalPostgres");
        configGenerator.SetNeedBackground(0);
        TServerConfigConstructorParams params(configGenerator.GetString().data());
        NDrive::TServerConfig config(params);
        NDrive::TServerGuard server(config);
        TEnvironmentGenerator eGenerator(*server);

        TVector<std::pair<TString, TString>> nameDataOrig = {
            {"name_0", "data_0"},
            {"name_1", "data_1"},
            {"name_2", "data_2"},
        };
        TVector<std::pair<TString, TString>> nameDataUpserted = {
            {"name_02", "data_0"},
            {"name_1", "data_1"},
            {"name_22", "data_22"},
            {"name_3", "data_3"}
        };

        const auto driveApi = server->GetDriveAPI();
        UNIT_ASSERT(driveApi);
        {
            auto session = driveApi->template BuildTx<NSQL::Writable>();
            auto transaction = session.GetTransaction();

            NStorage::IQueryResult::TPtr result = session->Exec(R"(DROP TABLE IF EXISTS replicator_test_data;)");
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());

            result = session->Exec(R"(CREATE TABLE replicator_test_data (id integer PRIMARY KEY NOT NULL, name text, data text);)");
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());

            auto table = transaction->GetDatabase().GetTable("replicator_test_data");
            UNIT_ASSERT(table);
            TRecordsSet recordSet;
            for (size_t i = 0; i < nameDataOrig.size(); ++i) {
                NStorage::TTableRecord record;
                record.ForceSet("id", ToString(i));
                record.ForceSet("name", nameDataOrig[i].first);
                record.ForceSet("data", nameDataOrig[i].second);
                recordSet.AddRow(std::move(record));
            }
            result = table->AddRows(recordSet, transaction);
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());
            UNIT_ASSERT_C(session.Commit(), session.GetStringReport());
        }
        {
            auto session = driveApi->template BuildTx<NSQL::Writable>();
            auto transaction = session.GetTransaction();
            auto table = transaction->GetDatabase().GetTable("replicator_test_data");
            TRecordsSet records;
            auto result = table->GetRows("", records, transaction);
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());
            UNIT_ASSERT_VALUES_EQUAL(records.size(), 3);
        }
        {
            auto session = driveApi->template BuildTx<NSQL::Writable>();
            auto transaction = session.GetTransaction();
            auto table = transaction->GetDatabase().GetTable("replicator_test_data");
            TRecordsSet recordSet;
            for (size_t i = 0; i < nameDataUpserted.size(); ++i) {
                if (i == 1) {
                    continue;
                }
                NStorage::TTableRecord record;
                record.ForceSet("id", ToString(i));
                record.ForceSet("name", nameDataUpserted[i].first);
                record.ForceSet("data", nameDataUpserted[i].second);
                recordSet.AddRow(std::move(record));
            }
            NStorage::IQueryResult::TPtr result = table->UpsertRows(recordSet, "id", transaction);
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());
            UNIT_ASSERT_C(session.Commit(), session.GetStringReport());
        }
        {
            auto session = driveApi->template BuildTx<NSQL::Writable>();
            auto transaction = session.GetTransaction();
            auto table = transaction->GetDatabase().GetTable("replicator_test_data");
            TRecordsSet records;
            auto result = table->GetRows("", records, transaction);
            UNIT_ASSERT_C(result->IsSucceed(), session.GetStringReport());
            UNIT_ASSERT_VALUES_EQUAL(records.size(), 4);
            for (auto&& record : records) {
                ui32 id;
                TString name, data;
                UNIT_ASSERT(record.TryGet("id", id));
                UNIT_ASSERT(record.TryGet("name", name));
                UNIT_ASSERT(record.TryGet("data", data));
                UNIT_ASSERT(id < nameDataUpserted.size());
                UNIT_ASSERT_VALUES_EQUAL(nameDataUpserted[id].first, name);
                UNIT_ASSERT_VALUES_EQUAL(nameDataUpserted[id].second, data);
            }
        }
    }
}
