#include <drive/backend/ut/library/helper.h>
#include <drive/backend/ut/library/helper2.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(LocalPostgresSimpleSuite) {
    Y_UNIT_TEST(StartServer) {
        TTestEnvironment env("LocalPostgres");
        env.Build();

        auto car = env.GetEnvironmentGenerator().CreateCar();
    }

    Y_UNIT_TEST(SequentialTableInfo) {
        TTestEnvironment env("LocalPostgres");
        env.Build();

        auto tableNames = {
            "car_tags_history",
            "user_tags_history",
        };
        for (auto&& tableName : tableNames) {
            INFO_LOG << "Testing " << tableName << Endl;
            auto table = IBaseSequentialTableImpl::Instance(tableName);
            UNIT_ASSERT(table);
            UNIT_ASSERT_VALUES_EQUAL(table->GetTableName(), tableName);
            NDrive::TEventId maxEventId;
            {
                auto tx = table->BuildTx<NSQL::Writable>();
                auto optionalMaxEventId = table->GetMaxEventIdOrThrow(tx);
                UNIT_ASSERT(optionalMaxEventId);
                maxEventId = *optionalMaxEventId;
                UNIT_ASSERT(maxEventId > 0);
            }
            {
                auto maxLockedEventId = table->GetLockedMaxEventId();
                UNIT_ASSERT_C(maxLockedEventId <= maxEventId, maxLockedEventId << " <= " << maxEventId);
            }
            {
                auto expectedMaxLockedEventId = table->TryGetLockedMaxEventId();
                UNIT_ASSERT(expectedMaxLockedEventId);
            }
        }
    }
}
