#include <drive/backend/ut/library/helper.h>

#include <drive/backend/tags/tags.h>
#include <drive/backend/tags/tags_manager.h>

#include <library/cpp/testing/unittest/registar.h>

#include <util/random/random.h>

Y_UNIT_TEST_SUITE(LocalizationSuite) {

    Y_UNIT_TEST(Simple) {
        NDrive::TServerConfigGenerator gServer;
        TServerConfigConstructorParams params(gServer.GetString().data());
        NDrive::TServerConfig config(params);
        NDrive::TServerGuard server(config);
        TEnvironmentGenerator eGenerator(*server.Get());
        eGenerator.BuildEnvironment();

        NLocalization::TResource resource;
        const TString testId = "test_" + ToString(RandomNumber<ui64>());
        resource.SetId(testId);
        resource.MutableLocalizations().emplace_back(::ToString(ELocalization::Eng), "yes");
        resource.MutableLocalizations().emplace_back(::ToString(ELocalization::Rus), "da");
        UNIT_ASSERT(gServer.UpsertLocalization(resource, USER_ROOT_DEFAULT));
        TVector<NLocalization::TResource> result;
        UNIT_ASSERT(gServer.GetLocalizations(USER_ROOT_DEFAULT, result));
        bool found = false;
        for (auto&& i : result) {
            if (i.GetId() == testId) {
                UNIT_ASSERT_VALUES_EQUAL(*i.GetLocalization(ELocalization::Rus), "da");
                found = true;
                resource.SetRevision(i.GetRevision());
                break;
            }
        }
        UNIT_ASSERT(found);
        resource.MutableLocalizations().clear();
        resource.MutableLocalizations().emplace_back(::ToString(ELocalization::Rus), "da1");
        Sleep(TDuration::Seconds(2));
        UNIT_ASSERT(gServer.UpsertLocalization(resource, USER_ROOT_DEFAULT));
        UNIT_ASSERT(gServer.GetLocalizations(USER_ROOT_DEFAULT, result));
        found = false;
        for (auto&& i : result) {
            if (i.GetId() == testId) {
                UNIT_ASSERT_VALUES_EQUAL(*i.GetLocalization(ELocalization::Rus), "da1");
                found = true;
                break;
            }
        }
        UNIT_ASSERT(found);

        UNIT_ASSERT(gServer.RemoveLocalization(testId, USER_ROOT_DEFAULT));
        UNIT_ASSERT(gServer.GetLocalizations(USER_ROOT_DEFAULT, result));
        for (auto&& i : result) {
            UNIT_ASSERT(i.GetId() != testId);
        }

        auto car = eGenerator.CreateCar();
        resource.SetId("standart_offer_description");
        {
            TVector<NLocalization::TResource> result;
            UNIT_ASSERT(gServer.GetLocalizations(USER_ROOT_DEFAULT, result, {"standart_offer_description"}));
            if (!result.empty()) {
                resource.SetRevision(result.front().GetRevision());
            }
        }
        resource.MutableLocalizations().clear();
        resource.MutableLocalizations().emplace_back(::ToString(ELocalization::Rus), "!!!!!!!!");
        UNIT_ASSERT(gServer.UpsertLocalization(resource, USER_ROOT_DEFAULT));
        Sleep(TDuration::Seconds(5));

        {
            NJson::TJsonValue report;
            TString offerId = gServer.CreateOffer(car.Id, USER_ID_DEFAULT, &report);
            UNIT_ASSERT(!!offerId);
            INFO_LOG << report << Endl;
            UNIT_ASSERT_VALUES_EQUAL(report["offers"][0]["detailed_description"].GetStringRobust(), "abc dfee !!!!!!!! sasdasdasd offer_signature finish");
        }

    }

}
