#include <drive/backend/ut/library/helper.h>

Y_UNIT_TEST_SUITE(Notifiers) {
    Y_UNIT_TEST(Propositions) {
        NDrive::TServerConfigGenerator configGenerator;
        TServerConfigConstructorParams params(configGenerator.GetString().data());
        NDrive::TServerConfig config(params);
        NDrive::TServerGuard server(config);
        TEnvironmentGenerator eGenerator(*server.Get());

        NJson::TJsonValue mailNotifierDesc = NJson::TMapBuilder("type", "mock")
            ("name", "mock_notifier")("meta", NJson::JSON_MAP);
        NJson::TJsonValue requestData = mailNotifierDesc;

        auto notifiersInfo = configGenerator.NotifiersInfo(USER_ROOT_DEFAULT);
        UNIT_ASSERT(notifiersInfo["objects"].IsArray());
        auto currentNotifiersAmount = notifiersInfo["objects"].GetArray().size();

        UNIT_ASSERT(configGenerator.ProposeNotifier(requestData, USER_ROOT_DEFAULT));

        auto propositionList = configGenerator.ListNotifierPropositions(USER_ROOT_DEFAULT);
        UNIT_ASSERT(propositionList["propositions"].IsArray());
        UNIT_ASSERT_VALUES_EQUAL(propositionList["propositions"].GetArray().size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(propositionList["propositions"].GetArray().front()["name"], "mock_notifier");
        UNIT_ASSERT(propositionList["propositions"].GetArray().front()["proposition_id"].IsString());

        auto propositionId = propositionList["propositions"].GetArray().front()["proposition_id"].GetString();
        UNIT_ASSERT(configGenerator.ConfirmNotifier(propositionId, USER_ROOT_DEFAULT));

        propositionList = configGenerator.ListNotifierPropositions(USER_ROOT_DEFAULT);
        UNIT_ASSERT(propositionList["propositions"].IsArray());
        UNIT_ASSERT_VALUES_EQUAL(propositionList["propositions"].GetArray().size(), 0);
        SendGlobalMessage<NDrive::TCacheRefreshMessage>();

        notifiersInfo = configGenerator.NotifiersInfo(USER_ROOT_DEFAULT);
        UNIT_ASSERT(notifiersInfo["objects"].IsArray());
        UNIT_ASSERT_VALUES_EQUAL(notifiersInfo["objects"].GetArray().size(), currentNotifiersAmount + 1);
    }
}
