#include <drive/backend/ut/library/script.h>

#include <drive/backend/data/device_tags.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(Propositions) {
    using namespace NDrive::NTest;
    Y_UNIT_TEST(CarTagsSimple) {
        NDrive::TServerConfigGenerator configGenerator;
        configGenerator.SetLogLevel(7);
        TGeoCoord from(37.5848674, 55.7352435);
        TGeoCoord to(37.5675511, 55.7323499);
        NDrive::NTest::TScript script(configGenerator);
        script.Add<TBuildEnv>();
        script.Add<TCreateCar>().SetPosition(from);

        auto checkerTagVisibility = [](const NJson::TJsonValue& report, TRTContext& /*context*/) {
            const NJson::TJsonValue::TMapType* map;
            UNIT_ASSERT(report.GetMapPointer(&map));
            auto it = map->find("tags");
            UNIT_ASSERT(it != map->end());

            const NJson::TJsonValue::TMapType* mapTags;
            UNIT_ASSERT(it->second.GetMapPointer(&mapTags));
            UNIT_ASSERT(mapTags->contains("old_state_reservation"));
            auto itTagInfo = mapTags->find("force_stop_car_simple1");
            if (itTagInfo != mapTags->end()) {
                UNIT_ASSERT_VALUES_EQUAL(itTagInfo->second["cars_count"].GetIntegerSafe(), 0);
            }
        };

        script.Add<TCheckCarsReport>().SetChecker(checkerTagVisibility).SetActionUserId(USER_ROOT_DEFAULT);
        script.Add<TProposeTag>(new TDeviceTagRecord("force_stop_car_simple1")).SetActionUserId(USER_ID_DEFAULT);
//        script.Add<TDropCache>();
        script.Add<TListTagPropositions>().SetActionUserId(USER_ID_DEFAULT);
        script.Add<TCheckCarsReport>().SetChecker(checkerTagVisibility).SetActionUserId(USER_ROOT_DEFAULT);
        script.Add<TConfirmTag>(TDuration::Zero()).SetActionUserId(USER_ROOT_DEFAULT);


        auto checkerConfirmTagVisibility = [](const NJson::TJsonValue& report, TRTContext& /*context*/) {
            const NJson::TJsonValue::TMapType* map;
            UNIT_ASSERT(report.GetMapPointer(&map));
            auto it = map->find("tags");
            UNIT_ASSERT(it != map->end());

            const NJson::TJsonValue::TMapType* mapTags;
            UNIT_ASSERT(it->second.GetMapPointer(&mapTags));
            UNIT_ASSERT(mapTags->contains("old_state_reservation"));
            UNIT_ASSERT(mapTags->contains("force_stop_car_simple1"));

            auto itTagInfo = mapTags->find("force_stop_car_simple2");
            if (itTagInfo != mapTags->end()) {
                UNIT_ASSERT_VALUES_EQUAL(itTagInfo->second["cars_count"].GetIntegerSafe(), 0);
            }
        };

        script.Add<TCheckCarsReport>().SetChecker(checkerConfirmTagVisibility).SetActionUserId(USER_ROOT_DEFAULT);
        script.Add<TProposeTag>(new TDeviceTagRecord("force_stop_car_simple2")).SetActionUserId(USER_ID_DEFAULT);
        script.Add<TListTagPropositions>().SetActionUserId(USER_ID_DEFAULT);
//        script.Add<TDropCache>();
        script.Add<TRejectTag>().SetActionUserId(USER_ROOT_DEFAULT);
        script.Add<TCheckCarsReport>().SetChecker(checkerConfirmTagVisibility).SetActionUserId(USER_ROOT_DEFAULT);
        UNIT_ASSERT(script.Execute());
    }
}
