#include <drive/backend/ut/library/script.h>
#include <drive/backend/rt_background/radar/processor.h>
#include <drive/backend/ut/rt_background/test/config.h>
#include <drive/backend/processors/car_scanner/processor.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(RadarRobot) {

    TMap<TString, TString> radarSettings = {
        {"handlers.default.radar.create_tag.enabled", "true"},
        {"radar.close_session.enabled", "true"},
        {"radar.use_geohash_add", "true"},
        {"radar.use_geohash_remove", "true"},
        {"radar.use_geohash_find", "true"},
    };

    Y_UNIT_TEST(SimpleOrder) {
        NDrive::TServerConfigGenerator gen;
        gen.SetNeedBackground(0);
        TGeoCoord from(37.52175528, 55.71331785);
        NDrive::NTest::TScript script(gen);
        script.Add<NDrive::NTest::TBuildEnv>();
        script.Add<NDrive::NTest::TSetSetting>().Reset(radarSettings);
        script.Add<NDrive::NTest::TSetScriptUser>(USER_ID_DEFAULT);
        script.Add<NDrive::NTest::TCreateCar>().SetPosition(TGeoCoord(37.5238721, 55.71331785));
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& /*context*/) {
            UNIT_ASSERT(gen.StartScanner(USER_ID_DEFAULT, from, "filter_porsche_carrera", TDuration::Seconds(1000), "order"));
        });
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& context) {
            auto process = MakeHolder<TRadarUserTagProcess>();
            process->SetPeriod(TDuration::Seconds(5));
            process->SetEnabled(true);
            process->SetRobotUserId(USER_ROOT_DEFAULT);
            TRTBackgroundProcessContainer container(process.Release());
            container.SetName("radar_user_tag_process");
            UNIT_ASSERT(context.GetConfigGenerator().ForceUpsertRTBackground(container, USER_ROOT_DEFAULT));
            Sleep(TDuration::Seconds(20));
        });
        const auto sessionChecker = [](const NJson::TJsonValue& userSessionReport) {
            UNIT_ASSERT(userSessionReport["segment"]["meta"]["finished"].IsBoolean());
            UNIT_ASSERT(!userSessionReport["segment"]["meta"]["finished"].GetBoolean());
        };
        script.Add<NDrive::NTest::TSleepAction>().SetWaitingDuration(TDuration::Seconds(100));
        script.Add<NDrive::NTest::TCheckCurrentSession>(sessionChecker).SetUserId(USER_ID_DEFAULT).SetExpectOK(true);
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& context) {
            auto session = context.GetDriveAPI().BuildTx<NSQL::ReadOnly>();
            auto radarPushTag = context.GetDriveAPI().GetTagsManager().GetUserTags().RestoreEntityTags(USER_ID_DEFAULT, { "radarpush_booked" }, session);
            UNIT_ASSERT(radarPushTag);
            UNIT_ASSERT_EQUAL(radarPushTag->size(), 1);
        });
        UNIT_ASSERT(script.Execute());
    }

    Y_UNIT_TEST(SimpleSearch) {
        NDrive::TServerConfigGenerator gen;
        gen.SetNeedBackground(0);
        TGeoCoord from(37.52175528, 55.71331785);
        NDrive::NTest::TScript script(gen);
        script.Add<NDrive::NTest::TBuildEnv>();
        script.Add<NDrive::NTest::TSetSetting>().Reset(radarSettings);
        script.Add<NDrive::NTest::TSetScriptUser>(USER_ID_DEFAULT);
        script.Add<NDrive::NTest::TCreateCar>().SetPosition(TGeoCoord(37.519112, 55.713327));
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& /*context*/) {
            UNIT_ASSERT(gen.StartScanner(USER_ID_DEFAULT, from, "filter_porsche_carrera", TDuration::Seconds(1000), "search"));
        });
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& context) {
            auto actor = MakeHolder<TRadarUserTagProcess>();
            actor->SetPeriod(TDuration::Seconds(5));
            actor->SetEnabled(true);
            actor->SetRobotUserId(USER_ROOT_DEFAULT);
            TRTBackgroundProcessContainer container(actor.Release());
            container.SetName("radar_user_tag_process");
            UNIT_ASSERT(context.GetConfigGenerator().ForceUpsertRTBackground(container, USER_ROOT_DEFAULT));
            Sleep(TDuration::Seconds(20));
        });
        script.Add<NDrive::NTest::TSleepAction>().SetWaitingDuration(TDuration::Seconds(100));
        script.Add<NDrive::NTest::TCommonChecker>([&](NDrive::NTest::TRTContext& context) {
            auto session = context.GetDriveAPI().BuildTx<NSQL::ReadOnly>();
            auto radarPushTag = context.GetDriveAPI().GetTagsManager().GetUserTags().RestoreEntityTags(USER_ID_DEFAULT, { "radarpush_found" }, session);
            UNIT_ASSERT(radarPushTag);
            UNIT_ASSERT_EQUAL(radarPushTag->size(), 1);
        });
        UNIT_ASSERT(script.Execute());
    }
}
