#include <drive/backend/ut/library/car_driver.h>
#include <drive/backend/ut/library/helper.h>
#include <drive/backend/ut/library/script.h>

#include <drive/backend/background/car_markers/config.h>
#include <drive/backend/base/config.h>
#include <drive/backend/base/server.h>
#include <drive/backend/cars/car.h>
#include <drive/backend/data/area_tags.h>
#include <drive/backend/data/alerts/tags.h>
#include <drive/backend/data/chargable.h>
#include <drive/backend/data/device_tags.h>
#include <drive/backend/data/user_tags.h>
#include <drive/backend/device_snapshot/image.h>
#include <drive/backend/offers/actions/pack.h>
#include <drive/backend/offers/actions/standart.h>
#include <drive/backend/processors/service_app/processor.h>
#include <drive/backend/processors/user_app/processor.h>
#include <drive/backend/tags/tag.h>
#include <drive/backend/tags/tags.h>
#include <drive/backend/tags/tags_manager.h>
#include <drive/backend/users/login.h>

#include <drive/telematics/client/library/handlers.h>
#include <drive/telematics/server/library/server.h>
#include <drive/telematics/server/ut/library/helper.h>

#include <kernel/daemon/config/config_constructor.h>
#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <rtline/library/storage/structured.h>

Y_UNIT_TEST_SUITE(SelfieVerification) {
    using namespace NDrive::NTest;
    Y_UNIT_TEST(CompleteScenario) {
        NDrive::TServerConfigGenerator configGenerator;
        configGenerator.SetLogLevel(6);
        TGeoCoord from(37.5848674, 55.7352435);
        TGeoCoord to(37.5675511, 55.7323499);
        NDrive::NTest::TScript script(configGenerator);
        script.Add<TBuildEnv>(TDuration::Zero());
        script.Add<TCreateCar>().SetPosition(from);
        {
            NJson::TJsonValue jsonLanding;
            jsonLanding["text"] = "some alert text";
            jsonLanding["payload_patch"]["user_choice"] = "accept";
            script.Add<TAddLanding>("selfie_verification_required", jsonLanding.GetStringRobust());
        }

        // Ride without selfie verification
        script.Add<TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("standart_offer_constructor").SetUserPosition(from);
        script.Add<TAccept>();
        script.Add<TRide>();
        script.Add<TDrop>().SetCarPosition(to).SetExpectOK(true);

        // Require selfie verification
        script.Add<TCreateCar>().SetPosition(from);
        script.Add<TAddTag>(new TUniqueUserTag("need_selfie_verification")).SetObjectId(USER_ID_DEFAULT).SetEntityType(NEntityTagsManager::EEntityType::User);
        script.Add<TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("standart_offer_constructor").SetUserPosition(from);
        script.Add<TAccept>();
        script.Add<TRide>().SetAlertLandingId("selfie_verification_required");
        script.Add<TDrop>().SetCarPosition(to).SetExpectOK(true);

        // The tag is not yet removed, so we'll ask for selfie verification again
        script.Add<TCreateCar>().SetPosition(from);
        script.Add<TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("standart_offer_constructor").SetUserPosition(from);
        script.Add<TAccept>();
        script.Add<TRide>().SetAlertLandingId("selfie_verification_required");
        script.Add<TDrop>().SetCarPosition(to).SetExpectOK(true);

        // Eventually the selfie photo is sent
        script.Add<TSubmitDocumentPhoto>().SetType(NUserDocument::EType::Selfie).SetContent("meow1234").SetAdditionalLength(3);
        script.Add<TGetDocumentPhoto>().SetType(NUserDocument::EType::Selfie).SetContent("{\"content\":\"meow123");
        script.Add<TGetDocumentVideo>().SetType(NUserDocument::EType::Selfie).SetContent("4\"}");

        // And there is no longer a verification landing on acceptance
        script.Add<TCreateCar>().SetPosition(from);
        script.Add<TCreateAndBookOffer>().SetUserDestination(to).SetOfferName("standart_offer_constructor").SetUserPosition(from);
        script.Add<TAccept>();
        script.Add<TRide>();
        script.Add<TDrop>().SetCarPosition(to).SetExpectOK(true);

        // Tag evolved to yang assignment
        script.Add<TCheckHasTag>().SetTagName("need_selfie_verification").SetExpectOK(false);
        script.Add<TCheckHasTag>().SetTagName("selfie_verification_upload").SetExpectOK(true);

        UNIT_ASSERT(script.Execute());
    }
}
