#include <drive/backend/ut/library/helper2.h>

#include <drive/backend/data/chargable.h>
#include <drive/backend/sessions/manager/billing.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(BillingSession) {
    Y_UNIT_TEST(Manager) {
        TTestEnvironment env;
        env.Execute(NDrive::NTest::TBuildEnv());

        const auto& api = *Yensured(env.GetServer()->GetDriveAPI());
        const auto& sessionManager = api.GetSessionManager();

        auto carId = TString{OBJECT_ID_DEFAULT};
        auto userId = TString{USER_ID_DEFAULT};
        auto offerId = env->CreateOffer(carId, userId);
        UNIT_ASSERT(offerId);
        UNIT_ASSERT(env->BookOffer(offerId, userId));
        {
            auto tx = api.BuildTx<NSQL::ReadOnly>();
            auto optionalChargableSessionTag = TChargableSessionTag::Get(offerId, api.GetTagsManager(), tx);
            UNIT_ASSERT(optionalChargableSessionTag);
            auto chargableSessionTag = optionalChargableSessionTag->GetTagAs<TChargableSessionTag>();
            UNIT_ASSERT(chargableSessionTag);
        }
        auto stage = TString("old_state_reservation");
        auto checkSession = [&](TSessionManager::TSessionConstPtr session) {
            UNIT_ASSERT(session);
            UNIT_ASSERT_VALUES_EQUAL(session->GetLastEvent().GetRef()->GetName(), stage);
            UNIT_ASSERT_VALUES_EQUAL(session->GetSessionId(), offerId);
            UNIT_ASSERT_VALUES_EQUAL(session->GetUserId(), userId);
        };
        auto evolveSession = [&](const TString& to) {
            stage = to;
            UNIT_ASSERT(env->EvolveTag(stage, userId));
        };
        {
            auto tx = api.BuildTx<NSQL::ReadOnly>();

            INFO_LOG << stage << ": checking GetSession" << Endl;
            auto optionalSession = sessionManager.GetSession(offerId, tx);
            UNIT_ASSERT(optionalSession);
            checkSession(*optionalSession);

            INFO_LOG << stage << ": checking GetObjectSessions" << Endl;
            auto objectSessions = sessionManager.GetObjectSessions(carId, tx);
            UNIT_ASSERT(objectSessions);
            UNIT_ASSERT_VALUES_EQUAL(objectSessions->size(), 1);
            checkSession(objectSessions->front());

            INFO_LOG << stage << ": checking GetUserSessions" << Endl;
            auto userSessions = sessionManager.GetUserSessions(userId, tx);
            UNIT_ASSERT(userSessions);
            UNIT_ASSERT_VALUES_EQUAL(userSessions->size(), 1);
            checkSession(userSessions->front());

            INFO_LOG << stage << ": checking GetSession" << Endl;
            optionalSession = sessionManager.GetSession(offerId, tx);
            UNIT_ASSERT(optionalSession);
            checkSession(*optionalSession);
        }
        evolveSession("old_state_acceptance");
        {
            auto tx = api.BuildTx<NSQL::ReadOnly>();

            INFO_LOG << stage << ": checking GetSession" << Endl;
            auto optionalSession = sessionManager.GetSession(offerId, tx);
            UNIT_ASSERT(optionalSession);
            checkSession(*optionalSession);
        }
        evolveSession("old_state_reservation");
        {
            auto tx = api.BuildTx<NSQL::ReadOnly>();
            auto optionalChargableSessionTag = TChargableSessionTag::Get(offerId, api.GetTagsManager(), tx);
            UNIT_ASSERT(optionalChargableSessionTag);
            UNIT_ASSERT(!*optionalChargableSessionTag);
        }
    }
}
