#include <drive/backend/ut/library/helper2.h>

Y_UNIT_TEST_SUITE(Status) {
    Y_UNIT_TEST(SensorFilter) {
        TTestEnvironment env;
        env.Build();
        env.GetTelematicServerBuilder().Run();

        const auto car = env.GetEnvironmentGenerator().CreateCar();
        const auto& server = *env.GetServer();
        UNIT_ASSERT(env->WaitStatus(car.Id, "available", server));

        const auto emulator = env.GetTelematicServerBuilder().BuildEmulator(car.IMEI);
        UNIT_ASSERT(emulator);
        emulator->GetContext().SetOdometerKm(21 * 10000);
        UNIT_ASSERT(env->WaitSensor(car.Id, "mileage", "210000"));
        UNIT_ASSERT(env->WaitStatus(car.Id, "huge_mileage", server));
    }
}
