#include <drive/backend/ut/library/helper2.h>

#include <drive/backend/actions/evolution_policy.h>

#include <drive/telematics/server/ut/library/helper.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(Taxisharing) {
    Y_UNIT_TEST(FuelLevelThreshold) {
        TTestEnvironment env;
        env.Execute(NDrive::NTest::TBuildEnv());
        {
            auto action = MakeAtomicShared<TTaxisharingEvolutionPolicyAction>();
            action->SetName("taxisharing_fuel_level_threshold_test");
            RegisterAction(*env.GetServer(), action, "default_user");
        }
        auto emulator = env.GetContext().GetEmulator();
        UNIT_ASSERT(emulator);
        emulator->GetContext().SetFuelPercent(42);
        SendGlobalMessage<NDrive::TCacheRefreshMessage>();

        auto carId = TString{OBJECT_ID_DEFAULT};
        auto userId = TString{USER_ID_DEFAULT};
        auto offerId = env->CreateOffer(carId, userId);
        UNIT_ASSERT(offerId);
        UNIT_ASSERT(env->BookOffer(offerId, userId));
        UNIT_ASSERT(env->EvolveTag("old_state_acceptance", userId));
        UNIT_ASSERT(env->EvolveTag("old_state_riding", userId));
        UNIT_ASSERT(env->WaitSensor(carId, "fuel_level", "42"));
        UNIT_ASSERT(!env->EvolveTag("old_state_reservation", userId));
    }
}
