#include <drive/backend/ut/library/script.h>

#include <drive/backend/offers/actions/pack.h>
#include <drive/backend/processors/warning_screen/checker.h>

#include <library/cpp/testing/unittest/registar.h>

#include <rtline/library/json/builder.h>

namespace {
    class TEchoChecker: public IWarningScreenChecker {
    public:
        static const TString Name;
        static IWarningScreenChecker::TFactory::TRegistrator<TEchoChecker> Registrator;

        TString GetName() const override {
            return Name;
        }

    private:
        NJson::TJsonValue CheckImpl(const NDrive::IServer& /*server*/, const IReplyContext::TPtr /*context*/, TUserPermissions::TConstPtr /*permissions*/) const override {
            return NJson::TJsonValue("echo");
        }
    };
    const TString TEchoChecker::Name = "echo_checker";
    IWarningScreenChecker::TFactory::TRegistrator<TEchoChecker> TEchoChecker::Registrator(
            TEchoChecker::Name);

    class TErrorChecker: public IWarningScreenChecker {
    public:
        static const TString Name;
        static IWarningScreenChecker::TFactory::TRegistrator<TErrorChecker> Registrator;

        TString GetName() const override {
            return Name;
        }

    private:
        NJson::TJsonValue CheckImpl(const NDrive::IServer& /*server*/, const IReplyContext::TPtr /*context*/, TUserPermissions::TConstPtr /*permissions*/) const override {
            throw yexception() << "error checker";
        }
    };
    const TString TErrorChecker::Name = "error_checker";
    IWarningScreenChecker::TFactory::TRegistrator<TErrorChecker> TErrorChecker::Registrator(
            TErrorChecker::Name);
}  // namespace

namespace NDrive::NTest {
    Y_UNIT_TEST_SUITE(WarningScreenTestSuite) {
        Y_UNIT_TEST(EventsProcessorSmoke) {
            NDrive::TServerConfigGenerator configGenerator;
            configGenerator.SetNeedBackground(0);

            TScript script(configGenerator);
            script.Add<TBuildEnv>();
            script.Add<TSetScriptUser>(USER_ROOT_DEFAULT);
            script.Add<TSetSetting>().Set("warning_screens.events.test_event.missing_checker.enabled", "true");
            script.Add<TSetSetting>().Set(TStringBuilder() << "warning_screens.events.test_event."
                                                           << TEchoChecker::Name << ".enabled",
                                          "true");
            script.Add<TSetSetting>().Set(TStringBuilder() << "warning_screens.events.test_event."
                                                           << TErrorChecker::Name << ".enabled",
                                          "true");
            script.Add<TSetSetting>().Set(TStringBuilder() << "warning_screens.events.test_event."
                                                           << TEchoChecker::Name << ".priority",
                                          "10");
            script.Add<TSetSetting>().Set(TStringBuilder() << "warning_screens.events.test_event."
                                                           << TErrorChecker::Name << ".priority",
                                          "20");

            script.Add<TWarningScreenChecker>("test_event", [](const NJson::TJsonValue& response) {
                const TString message = response.GetStringRobust();
                UNIT_ASSERT_C(response["items"] == NJson::TArrayBuilder("echo"), message);
                UNIT_ASSERT_C(response["errors"].GetMap().size() == 1, message);
                UNIT_ASSERT_C(response["errors"]["error_checker"] == "error checker", message);
            });

            UNIT_ASSERT(script.Execute());
        }
    }
}  // namespace NDrive::NTest
