UNITTEST()

ALLOCATOR(TCMALLOC_256K)

OWNER(g:drive-backend)

DATA(sbr://1685328775=geobase)

PEERDIR(
    drive/backend/actions
    drive/backend/alerts
    drive/backend/background
    drive/backend/base
    drive/backend/billing/ut/library
    drive/backend/chat_robots
    drive/backend/chat_robots/registration
    drive/backend/chat_robots/suggest
    drive/backend/common
    drive/backend/data
    drive/backend/data/alerts
    drive/backend/data/leasing
    drive/backend/data/complaint_tags
    drive/backend/database
    drive/backend/database/drive
    drive/backend/device_snapshot
    drive/backend/documents_verification
    drive/backend/offers
    drive/backend/offers/actions/ut/library
    drive/backend/offers/price
    drive/backend/processors/areas
    drive/backend/processors/car_models
    drive/backend/processors/car_preparation
    drive/backend/processors/car_scanner
    drive/backend/processors/drivematics
    drive/backend/processors/external_chat
    drive/backend/processors/external_offer
    drive/backend/processors/fueling
    drive/backend/processors/landing
    drive/backend/processors/localization
    drive/backend/processors/mds
    drive/backend/processors/offers_construction
    drive/backend/processors/offers_timetable
    drive/backend/processors/offers_update
    drive/backend/processors/organization/list
    drive/backend/processors/rt_background
    drive/backend/processors/service_app
    drive/backend/processors/service_tags
    drive/backend/processors/support_center
    drive/backend/processors/user_app
    drive/backend/processors/user_roles
    drive/backend/processors/users
    drive/backend/processors/warning_screen
    drive/backend/registrar
    drive/backend/roles
    drive/backend/rt_background/attachments_expiration_watcher
    drive/backend/rt_background/billing
    drive/backend/rt_background/datasync_manager
    drive/backend/rt_background/manager
    drive/backend/rt_background/radar
    drive/backend/rt_background/sensor_tags
    drive/backend/rt_background/service_routes
    drive/backend/rt_background/drop_performer
    drive/backend/rt_background/toll_roads
    drive/backend/rt_background/user_push_sender
    drive/backend/rt_background/rental
    drive/backend/support_center
    drive/backend/tags
    drive/backend/user_document_photos
    drive/backend/ut/library
    drive/backend/ut/library/scripts
    drive/backend/ut/rt_background/test
    drive/backend/yang
    drive/library/cpp/takeout
    drive/library/cpp/tracks
    drive/library/cpp/weather
    drive/telematics/client/library
    drive/telematics/server/library
    drive/telematics/server/ut/library
    drive/tests/library
    library/cpp/iterator
    rtline/library/async_proxy/ut/helper
    rtline/library/storage/redis
    rtline/util/algorithm
)

TIMEOUT(600)

SIZE(MEDIUM)

SRCS(
    GLOBAL tags_ut.cpp
    acl_ut.cpp
    alerts_ut.cpp
    area_ut.cpp
    b2b_ut.cpp
    balance_client_ut.cpp
    bans_ut.cpp
    billing_info_ut.cpp
    calculator_ut.cpp
    car_complaint_ut.cpp
    car_preparation_ut.cpp
    chat_landings_ut.cpp
    chat_math_ut.cpp
    datasync_queue_ut.cpp
    dedicated_fleet_ut.cpp
    delegation_ut.cpp
    documents_checks_ut.cpp
    documents_verification_ut.cpp
    double_rent_ut.cpp
    dynamic_riding_price_ut.cpp
    encrypted_ut.cpp
    entities_ut.cpp
    evolutions_ut.cpp
    external_access_token_ut.cpp
    external_chats_ut.cpp
    external_offers_ut.cpp
    fast_registration_ut.cpp
    fixpoint_ut.cpp
    flexipack_ut.cpp
    fueling_ut.cpp
    futures_ut.cpp
    gdpr_ut.cpp
    head_ut.cpp
    landings_propose_ut.cpp
    leasing_ut.cpp
    localization_ut.cpp
    long_term_ut.cpp
    mail_sender_ut.cpp
    maintenance_ut.cpp
    models_ut.cpp
    multiperforming_ut.cpp
    notifier_ut.cpp
    offers_ut.cpp
    parking_zones_ut.cpp
    paymethods_ut.cpp
    private_data_ut.cpp
    processor_ut.cpp
    promo_codes_ut.cpp
    propositions_ut.cpp
    radar_geohash_ut.cpp
    radar_robot_ut.cpp
    radar_ut.cpp
    registration_chat_ut.cpp
    renins_ut.cpp
    rental_offer_ut.cpp
    roles_ut.cpp
    rt_bg_ut.cpp
    search_ut.cpp
    selfie_verification_ut.cpp
    service_routes_ut.cpp
    sessions_ut.cpp
    signalq_ut.cpp
    status_ut.cpp
    subscription_tags_ut.cpp
    support_center_ut.cpp
    support_chat_context_ut.cpp
    support_chat_suggest_ut.cpp
    support_chat_ut.cpp
    switch_ut.cpp
    tags_manager_ut.cpp
    taxi_ut.cpp
    telematics_ut.cpp
    trust_redis_ut.cpp
    user_data_ut.cpp
    users_admin_ut.cpp
    verification_ut.cpp
    warning_screen_checks_ut.cpp
    warning_screen_pack_offer_ut.cpp
    warning_screen_ut.cpp
)

DEPENDS(
    drive/tests/resources/extmaps-carsharing-testing
    drive/tests/resources/sensors
    drive/tests/resources/state_schemes
)

DATA(arcadia/drive/backend/chat_robots/test_data)

REQUIREMENTS(
    cpu:4
    network:full ram:20
)

INCLUDE(${ARCADIA_ROOT}/library/python/redis_utils/recipe/recipe.inc)

FORK_SUBTESTS()

SPLIT_FACTOR(350)

END()
