#pragma once

#include <climits>
#include <mutex>
#include "egts/egts_response.hpp"
#include "socket.hpp"
#include "state.hpp"

namespace telemetry {

class EGTSService {
 public:
  EGTSService(const std::string& host, unsigned short port,
              const std::string& imei, std::chrono::milliseconds timeout);

  EGTSService(const EGTSService&) = delete;

  EGTSService& operator=(const EGTSService&) = delete;

  void Send(const std::vector<CarState>& cars);

 protected:
  void SendAuth(const std::string& imei);

  void ReceiveAuthAck();

  void ReceiveAuthResult();

  size_t ReceiveTeleDataAck();

  std::vector<uint8_t> SerializeAuth(const std::string& imei) const;

  std::vector<uint8_t> SerializeCars(
      const std::vector<CarState>::const_iterator carsBegin,
      const std::vector<CarState>::const_iterator carsEnd) const;

 private:
  void CheckConnection();

  EGTSResponse ReceiveResponse();

 private:
  static const size_t kChecksumFieldSize = 2;
  static const size_t kResponseBufferSize =
      sizeof(EGTS_PACKET_HEADER) + USHRT_MAX + kChecksumFieldSize;

 private:
  std::mutex mutex_;
  std::string host_;
  unsigned port_;
  std::string imei_;

  std::unique_ptr<Socket> socket_;
  std::chrono::milliseconds timeout_;

  std::unique_ptr<uint8_t[]> response_buf_;
};

}  // namespace telemetry
